/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.route;

import com.alibaba.fastjson.JSON;
import com.icetech.common.domain.route.RouteDefinition;
import com.icetech.common.domain.route.ServiceRouteInfo;
import com.icetech.web.bean.ServiceApiInfo;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.env.Environment;
import org.springframework.util.DigestUtils;

public class ServiceRouteInfoBuilder {
    private static final Logger log = LoggerFactory.getLogger(ServiceRouteInfoBuilder.class);
    private static final String PROTOCOL_LOAD_BALANCE = "lb://";
    private static final String PATH_SPLIT = "/";
    private static final String DEFAULT_CONTEXT_PATH = "/";
    private final Environment environment;

    public ServiceRouteInfoBuilder(Environment environment) {
        this.environment = environment;
    }

    public ServiceRouteInfo build(ServiceApiInfo serviceApiInfo) {
        return this.buildServiceGatewayInfo(serviceApiInfo);
    }

    protected ServiceRouteInfo buildServiceGatewayInfo(ServiceApiInfo serviceApiInfo) {
        List<ServiceApiInfo.ApiMeta> apis = serviceApiInfo.getApis();
        ArrayList<RouteDefinition> routeDefinitionList = new ArrayList<RouteDefinition>(apis.size());
        for (ServiceApiInfo.ApiMeta apiMeta : apis) {
            RouteDefinition routeDefinition = this.buildGatewayRouteDefinition(serviceApiInfo, apiMeta);
            routeDefinitionList.add(routeDefinition);
        }
        ServiceRouteInfo serviceRouteInfo = new ServiceRouteInfo();
        serviceRouteInfo.setServiceId(serviceApiInfo.getServiceId());
        serviceRouteInfo.setRouteDefinitionList(routeDefinitionList);
        serviceRouteInfo.setMd5(this.buildMd5(routeDefinitionList));
        return serviceRouteInfo;
    }

    protected RouteDefinition buildGatewayRouteDefinition(ServiceApiInfo serviceApiInfo, ServiceApiInfo.ApiMeta apiMeta) {
        RouteDefinition routeDefinition = new RouteDefinition();
        String routeId = apiMeta.fetchNameVersion();
        BeanUtils.copyProperties((Object)apiMeta, (Object)routeDefinition);
        routeDefinition.setId(routeId);
        routeDefinition.setFilters(Collections.emptyList());
        routeDefinition.setPredicates(Collections.emptyList());
        String uri = this.buildUri(serviceApiInfo, apiMeta);
        String path = this.buildServletPath(serviceApiInfo, apiMeta);
        routeDefinition.setUri(uri);
        routeDefinition.setPath(path);
        return routeDefinition;
    }

    protected String buildUri(ServiceApiInfo serviceApiInfo, ServiceApiInfo.ApiMeta apiMeta) {
        return PROTOCOL_LOAD_BALANCE + serviceApiInfo.getServiceId();
    }

    protected String buildServletPath(ServiceApiInfo serviceApiInfo, ServiceApiInfo.ApiMeta apiMeta) {
        String contextPath = this.getContextPathCompatibility();
        String servletPath = apiMeta.getPath();
        if (servletPath == null) {
            servletPath = "";
        }
        if (!servletPath.startsWith("/")) {
            servletPath = "/" + servletPath;
        }
        if ("/".equals(contextPath)) {
            return servletPath;
        }
        return contextPath + servletPath;
    }

    private String buildMd5(List<RouteDefinition> routeDefinitionList) {
        List routeIdList = routeDefinitionList.stream().map(JSON::toJSONString).sorted().collect(Collectors.toList());
        String md5Source = StringUtils.join(routeIdList, (String)"");
        return DigestUtils.md5DigestAsHex((byte[])md5Source.getBytes(StandardCharsets.UTF_8));
    }

    private String getContextPathCompatibility() {
        return this.environment.getProperty("server.servlet.context-path", this.environment.getProperty("server.context-path", "/"));
    }

    private void checkPath(String path, String errorMsg) {
        if (path.contains("/")) {
            throw new IllegalArgumentException(errorMsg);
        }
    }

    public Environment getEnvironment() {
        return this.environment;
    }
}

