/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.route;

import com.icetech.web.aop.anno.Open;
import com.icetech.web.bean.ServiceApiInfo;
import com.icetech.web.bean.ServiceConfig;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class ApiMetaBuilder {
    private static final String REGEX_API_NAME = "^[a-zA-Z0-9\\.\\_\\-]+$";

    public ServiceApiInfo getServiceApiInfo(String serviceId, RequestMappingHandlerMapping requestMappingHandlerMapping) {
        if (serviceId == null) {
            throw new IllegalArgumentException("\u8bf7\u5728application.properties\u4e2d\u6307\u5b9aspring.application.name\u5c5e\u6027");
        }
        List<ServiceApiInfo.ApiMeta> apis = this.buildApiMetaList(requestMappingHandlerMapping);
        apis.sort(Comparator.comparing(ServiceApiInfo.ApiMeta::fetchNameVersion));
        ServiceApiInfo serviceApiInfo = new ServiceApiInfo();
        serviceApiInfo.setServiceId(serviceId);
        serviceApiInfo.setApis(apis);
        return serviceApiInfo;
    }

    protected List<ServiceApiInfo.ApiMeta> buildApiMetaList(RequestMappingHandlerMapping requestMappingHandlerMapping) {
        Map handlerMethods = requestMappingHandlerMapping.getHandlerMethods();
        Set requestMappingInfos = handlerMethods.keySet();
        ArrayList<String> store = new ArrayList<String>();
        ArrayList<ServiceApiInfo.ApiMeta> apis = new ArrayList<ServiceApiInfo.ApiMeta>(requestMappingInfos.size());
        for (Map.Entry<RequestMappingInfo, HandlerMethod> entry : handlerMethods.entrySet()) {
            ServiceApiInfo.ApiMeta apiMeta = this.buildApiMeta(entry);
            if (apiMeta == null) continue;
            String key = apiMeta.fetchNameVersion();
            if (store.contains(key)) {
                throw new IllegalArgumentException("\u91cd\u590d\u7533\u660e\u63a5\u53e3\uff0c\u8bf7\u68c0\u67e5path\u548cversion\uff0cpath:" + apiMeta.getPath() + ", version:" + apiMeta.getVersion());
            }
            store.add(key);
            apis.add(apiMeta);
        }
        return apis;
    }

    protected ServiceApiInfo.ApiMeta buildApiMeta(Map.Entry<RequestMappingInfo, HandlerMethod> handlerMethodEntry) {
        RequestMappingInfo requestMappingInfo = handlerMethodEntry.getKey();
        Set patterns = requestMappingInfo.getPatternsCondition().getPatterns();
        Open open = (Open)handlerMethodEntry.getValue().getMethodAnnotation(Open.class);
        ServiceApiInfo.ApiMeta apiMeta = null;
        if (open != null) {
            String name = open.value();
            String version = open.version();
            if ("".equals(version)) {
                version = ServiceConfig.getInstance().getDefaultVersion();
            }
            String path = (String)patterns.iterator().next();
            this.checkApiName(name);
            apiMeta = new ServiceApiInfo.ApiMeta(name, path, version);
            apiMeta.setIgnoreValidate(BooleanUtils.toInteger((boolean)open.ignoreValidate()));
            apiMeta.setMergeResult(BooleanUtils.toInteger((boolean)open.mergeResult()));
            apiMeta.setPermission(BooleanUtils.toInteger((boolean)open.permission()));
            apiMeta.setNeedToken(BooleanUtils.toInteger((boolean)open.needToken()));
            apiMeta.setNotifyUrl(BooleanUtils.toInteger((boolean)open.notifyUrl()));
        }
        return apiMeta;
    }

    protected void checkApiName(String name) {
        if (!name.matches(REGEX_API_NAME)) {
            throw new IllegalArgumentException("\u63a5\u53e3\u540d\u79f0\u53ea\u5141\u8bb8\u3010\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u70b9(.)\u3001\u4e0b\u5212\u7ebf(_)\u3001\u51cf\u53f7(-)\u3011\uff0c\u9519\u8bef\u63a5\u53e3\uff1a" + name);
        }
    }
}

