package com.icetech.web.message;

/**
 * @author wgy
 */
public enum ServiceErrorEnum {
    /** 未知错误 */
    ISP_UNKNOWN_ERROR("isp.service-unknown-error"),
    /** 参数错误 */
    ISV_PARAM_ERROR("isv.invalid-parameter"),
    /** 请求方式不支持 */
    ISV_METHOD_NOT_ALLOWED("isv.method_not_allowed"),
    /** 通用错误 */
    ISV_COMMON_ERROR("isv.common-error"),
    ;
    private ServiceErrorMeta errorMeta;

    ServiceErrorEnum(String subCode) {
        this.errorMeta = new ServiceErrorMeta("isp.error_", subCode);
    }

    public ServiceErrorMeta getErrorMeta() {
        return errorMeta;
    }
}
