/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.utils;

import com.alibaba.fastjson.JSONObject;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.exception.ResponseBodyException;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.request.RequestContextHolder;

public class RequestKitBean {
    private static final Logger log = LoggerFactory.getLogger(RequestKitBean.class);
    @Autowired(required=false)
    protected HttpServletRequest request;
    private static final String REQ_CONTEXT_KEY_PARAMJSON = "REQ_CONTEXT_KEY_PARAMJSON";

    private String getReqParamFromBody() {
        String body = "";
        if (this.isConvertJSON()) {
            try {
                String str;
                while ((str = this.request.getReader().readLine()) != null) {
                    body = body + str;
                }
                return body;
            }
            catch (Exception e) {
                log.error("\u8bf7\u6c42\u53c2\u6570\u8f6c\u6362\u5f02\u5e38\uff01 params=[{}]", (Object)body);
                throw new ResponseBodyException(CodeConstantsEnum.ERROR.getCode(), "\u8f6c\u6362\u5f02\u5e38");
            }
        }
        return body;
    }

    private JSONObject reqParam2JSON() {
        JSONObject returnObject = new JSONObject();
        if (this.isConvertJSON()) {
            String body = "";
            try {
                body = this.request.getReader().lines().collect(Collectors.joining(""));
                if (StringUtils.isEmpty((CharSequence)body)) {
                    return returnObject;
                }
                return JSONObject.parseObject((String)body);
            }
            catch (Exception e) {
                log.error("\u8bf7\u6c42\u53c2\u6570\u8f6c\u6362\u5f02\u5e38\uff01 params=[{}]", (Object)body);
                throw new ResponseBodyException(CodeConstantsEnum.ERROR.getCode(), "\u8f6c\u6362\u5f02\u5e38");
            }
        }
        Map properties = this.request.getParameterMap();
        Iterator entries = properties.entrySet().iterator();
        String value = "";
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            String name = (String)entry.getKey();
            Object valueObj = entry.getValue();
            if (null == valueObj) {
                value = "";
            } else if (valueObj instanceof String[]) {
                String[] values = (String[])valueObj;
                for (int i = 0; i < values.length; ++i) {
                    value = values[i] + ",";
                }
                value = value.substring(0, value.length() - 1);
            } else {
                value = valueObj.toString();
            }
            if (!name.contains("[")) {
                returnObject.put(name, (Object)value);
                continue;
            }
            String mainKey = name.substring(0, name.indexOf("["));
            String subKey = name.substring(name.indexOf("[") + 1, name.indexOf("]"));
            JSONObject subJson = new JSONObject();
            if (returnObject.get((Object)mainKey) != null) {
                subJson = (JSONObject)returnObject.get((Object)mainKey);
            }
            subJson.put(subKey, (Object)value);
            returnObject.put(mainKey, (Object)subJson);
        }
        return returnObject;
    }

    public JSONObject getReqParamJSON() {
        Object reqParamObject = RequestContextHolder.getRequestAttributes().getAttribute(REQ_CONTEXT_KEY_PARAMJSON, 0);
        if (reqParamObject == null) {
            JSONObject reqParam = this.reqParam2JSON();
            RequestContextHolder.getRequestAttributes().setAttribute(REQ_CONTEXT_KEY_PARAMJSON, (Object)reqParam, 0);
            return reqParam;
        }
        return (JSONObject)reqParamObject;
    }

    private boolean isConvertJSON() {
        String contentType = this.request.getContentType();
        return contentType != null && contentType.toLowerCase().indexOf("application/json") >= 0 && !this.request.getMethod().equalsIgnoreCase("GET");
    }

    public String getClientIp() {
        String ipAddress = null;
        ipAddress = this.request.getHeader("x-forwarded-for");
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = this.request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = this.request.getHeader("WL-Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = this.request.getRemoteAddr();
        }
        if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }
}

