/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.message;

import com.icetech.web.message.ServiceError;
import com.icetech.web.message.ServiceErrorImpl;
import com.icetech.web.message.ServiceErrorMeta;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ServiceErrorFactory {
    private static final Logger log = LoggerFactory.getLogger(ServiceErrorFactory.class);
    public static final String SYS_ERR = "\u7cfb\u7edf\u9519\u8bef";
    private static final String I18N_OPEN_ERROR = "i18n/isp/error";
    private static Set<String> noModuleCache = new HashSet<String>();
    private static Map<String, ServiceError> errorCache = new HashMap<String, ServiceError>(64);
    private static MessageSourceAccessor errorMessageSourceAccessor;

    private ServiceErrorFactory() {
    }

    public static void initMessageSource(List<String> isvModules) {
        HashSet<String> baseNamesSet = new HashSet<String>();
        baseNamesSet.add(I18N_OPEN_ERROR);
        if (!isvModules.isEmpty()) {
            baseNamesSet.addAll(isvModules);
        }
        Object[] totalBaseNames = baseNamesSet.toArray(new String[0]);
        log.info("\u52a0\u8f7d\u9519\u8bef\u7801\u56fd\u9645\u5316\u8d44\u6e90\uff1a{}", (Object)StringUtils.arrayToCommaDelimitedString((Object[])totalBaseNames));
        ResourceBundleMessageSource bundleMessageSource = new ResourceBundleMessageSource();
        bundleMessageSource.setBasenames((String[])totalBaseNames);
        MessageSourceAccessor messageSourceAccessor = new MessageSourceAccessor((MessageSource)bundleMessageSource);
        ServiceErrorFactory.setErrorMessageSourceAccessor(messageSourceAccessor);
    }

    public static ServiceError getError(ServiceErrorMeta errorMeta, Locale locale, Object ... params) {
        String key = errorMeta.getModulePrefix() + errorMeta.getSubCode() + locale.toString();
        ServiceError error = errorCache.get(key);
        if (error == null) {
            Assert.notNull((Object)locale, (String)"\u672a\u8bbe\u7f6eLocale");
            String modulePrefix = errorMeta.getModulePrefix();
            String subCode = errorMeta.getSubCode();
            String subMsg = ServiceErrorFactory.getErrorMessage(modulePrefix + subCode, locale, params);
            if (StringUtils.isEmpty((Object)subMsg)) {
                subMsg = SYS_ERR;
            }
            error = new ServiceErrorImpl(subCode, subMsg);
            errorCache.put(key, error);
        }
        return error;
    }

    public static void setErrorMessageSourceAccessor(MessageSourceAccessor errorMessageSourceAccessor) {
        ServiceErrorFactory.errorMessageSourceAccessor = errorMessageSourceAccessor;
    }

    public static String getErrorMessage(String module, Locale locale, Object ... params) {
        if (noModuleCache.contains(module)) {
            return null;
        }
        try {
            return errorMessageSourceAccessor.getMessage(module, params, locale);
        }
        catch (Exception e) {
            noModuleCache.add(module);
            return null;
        }
    }
}

