/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.swagger;

import com.icetech.web.swagger.SwaggerValidator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerSecurityFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SwaggerSecurityFilter.class);
    protected List<String> urlFilters = new ArrayList<String>();
    private SwaggerValidator swaggerValidator;

    public SwaggerSecurityFilter(boolean swaggerAccessProtected) {
        this.urlFilters.add(".*?/doc\\.html.*");
        this.urlFilters.add(".*?/v2/api-docs.*");
        this.urlFilters.add(".*?/v2/api-docs-ext.*");
        this.urlFilters.add(".*?/swagger-resources.*");
        this.urlFilters.add(".*?/swagger-ui\\.html.*");
        this.urlFilters.add(".*?/swagger-resources/configuration/ui.*");
        this.urlFilters.add(".*?/swagger-resources/configuration/security.*");
        this.swaggerValidator = new SwaggerValidator(swaggerAccessProtected);
    }

    protected boolean match(String uri) {
        boolean match = false;
        if (uri != null) {
            for (String regex : this.urlFilters) {
                if (!uri.matches(regex)) continue;
                match = true;
                break;
            }
        }
        return match;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!this.swaggerValidator.swaggerAccessProtected()) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String uri = request.getRequestURI();
        if (!this.match(uri)) {
            filterChain.doFilter(servletRequest, servletResponse);
        } else if (this.swaggerValidator.validate(request)) {
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            this.swaggerValidator.writeForbidden(response);
        }
    }

    public void destroy() {
    }
}

