/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.web.bean;

import com.icetech.web.bean.ParamNames;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.time.DateUtils;

public interface OpenContext {
    public Map<String, Object> getParameterMap();

    default public String getParameter(String name) {
        Object value = this.getParameterMap().get(name);
        return value == null ? null : value.toString();
    }

    default public String getAppId() {
        return this.getParameter(ParamNames.APP_KEY_NAME);
    }

    default public String getCharset() {
        return this.getParameter(ParamNames.CHARSET_NAME);
    }

    default public String getMethod() {
        return this.getParameter(ParamNames.API_NAME);
    }

    default public String getVersion() {
        return this.getParameter(ParamNames.VERSION_NAME);
    }

    default public String getFormat() {
        return this.getParameter(ParamNames.FORMAT_NAME);
    }

    default public String getSignType() {
        return this.getParameter(ParamNames.SIGN_TYPE_NAME);
    }

    default public Date getTimestamp() {
        String timestampStr = this.getParameter(ParamNames.TIMESTAMP_NAME);
        try {
            return DateUtils.parseDate((String)timestampStr, (String[])new String[]{ParamNames.TIMESTAMP_PATTERN});
        }
        catch (ParseException e) {
            return null;
        }
    }

    default public String getAppAuthToken() {
        return this.getParameter(ParamNames.APP_AUTH_TOKEN_NAME);
    }

    default public String getNotifyUrl() {
        return this.getParameter(ParamNames.NOTIFY_URL_NAME);
    }
}

