package com.icetech.web.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import com.icetech.common.constants.CommonConstants;
import com.icetech.common.utils.Slf4jUtils;
import com.icetech.common.utils.StringUtils;
import lombok.extern.slf4j.Slf4j;

/**
 * <p>日志追踪器</p>
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0.5
 * @since Date 2021/7/26 10:01 上午
 */
@Slf4j
public class TraceFilter implements Filter {
    
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            String traceId = request instanceof HttpServletRequest ? ((HttpServletRequest)request).getHeader(CommonConstants.TRACE_ID_KEY) : null;
            if(StringUtils.isBlank(traceId)) {
                Object traceIdObj = request.getAttribute(CommonConstants.TRACE_ID_KEY);
                if (traceIdObj != null) traceId = traceIdObj.toString();
            }
            traceId = StringUtils.isBlank(traceId) ? Slf4jUtils.putTraceId() : Slf4jUtils.putTraceId(traceId);
            // 存储trace到Attribute以支持Dispatcher
            request.setAttribute(CommonConstants.TRACE_ID_KEY, traceId);
            chain.doFilter(request, response);
        } finally {
            Slf4jUtils.removeTraceId();
        }
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        log.info("[TraceFilter 初始化完成]");
    }

    @Override
    public void destroy() {
        log.info("[TraceFilter 销毁]");
    }

}
