/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.token.utils;

import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.util.ObjectUtil;
import com.icetech.common.utils.StringUtils;
import com.icetech.token.constants.UserConstants;
import com.icetech.token.enums.DeviceType;
import com.icetech.token.enums.UserType;
import com.icetech.token.model.LoginUser;

public class LoginHelper {
    public static final String JOIN_CODE = ":";
    public static final String LOGIN_USER_KEY = "loginUser";
    private static final ThreadLocal<LoginUser> LOGIN_CACHE = new ThreadLocal();

    public static void login(LoginUser loginUser) {
        LOGIN_CACHE.set(loginUser);
        StpUtil.login((Object)loginUser.getLoginId());
        LoginHelper.setLoginUser(loginUser);
    }

    public static void loginByDevice(LoginUser loginUser, DeviceType deviceType) {
        LOGIN_CACHE.set(loginUser);
        StpUtil.login((Object)loginUser.getLoginId(), (String)deviceType.getDevice());
        LoginHelper.setLoginUser(loginUser);
    }

    public static void setLoginUser(LoginUser loginUser) {
        StpUtil.getTokenSession().set(LOGIN_USER_KEY, (Object)loginUser);
    }

    public static LoginUser getLoginUser() {
        LoginUser loginUser = LOGIN_CACHE.get();
        if (loginUser != null) {
            return loginUser;
        }
        return (LoginUser)StpUtil.getTokenSession().get(LOGIN_USER_KEY);
    }

    public static void clearCache() {
        LOGIN_CACHE.remove();
    }

    public static Long getUserId() {
        LoginUser loginUser = LoginHelper.getLoginUser();
        if (ObjectUtil.isNull((Object)loginUser)) {
            String loginId = StpUtil.getLoginIdAsString();
            String userId = null;
            for (UserType value : UserType.values()) {
                if (!StringUtils.contains((CharSequence)loginId, (CharSequence)value.getUserType())) continue;
                String[] strs = StringUtils.split((String)loginId, (String)JOIN_CODE);
                userId = strs[strs.length - 1];
            }
            if (StringUtils.isBlank(userId)) {
                throw new UtilException("\u767b\u5f55\u7528\u6237: LoginId\u5f02\u5e38 => " + loginId);
            }
            return Long.parseLong(userId);
        }
        return loginUser.getUserId();
    }

    public static Long getDeptId() {
        return LoginHelper.getLoginUser().getDeptId();
    }

    public static String getUsername() {
        return LoginHelper.getLoginUser().getUsername();
    }

    public static UserType getUserType() {
        String loginId = StpUtil.getLoginIdAsString();
        return UserType.getUserType(loginId);
    }

    public static boolean isAdmin(Long userId) {
        return UserConstants.ADMIN_ID.equals(userId);
    }

    public static boolean isAdmin() {
        return LoginHelper.isAdmin(LoginHelper.getUserId());
    }

    private LoginHelper() {
    }
}

