/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.token.core.dao;

import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.util.SaFoxUtil;
import com.icetech.token.utils.RedisUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PlusSaTokenAloneRedisDao
implements SaTokenDao {
    private static final Logger log = LoggerFactory.getLogger(PlusSaTokenAloneRedisDao.class);
    public RedisUtils redisUtils;

    @Autowired
    public void init(RedissonClient redissonClient) {
        this.redisUtils = new RedisUtils(redissonClient);
    }

    public String get(String key) {
        log.info("\u83b7\u53d6token\u503c2 key {}", (Object)key);
        String value = (String)this.redisUtils.getCacheObject(key);
        log.info("\u83b7\u53d6token\u503c2 value {}", (Object)value);
        return value;
    }

    public void set(String key, String value, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        if (timeout == -1L) {
            this.redisUtils.setCacheObject(key, value);
        } else {
            this.redisUtils.setCacheObject(key, value, timeout, TimeUnit.SECONDS);
        }
    }

    public void update(String key, String value) {
        long expire = this.getTimeout(key);
        if (expire == -2L) {
            return;
        }
        this.set(key, value, expire);
    }

    public void delete(String key) {
        this.redisUtils.deleteObject(key);
    }

    public long getTimeout(String key) {
        return this.redisUtils.getTimeToLive(key) / 1000L;
    }

    public void updateTimeout(String key, long timeout) {
        if (timeout == -1L) {
            long expire = this.getTimeout(key);
            if (expire != -1L) {
                this.set(key, this.get(key), timeout);
            }
            return;
        }
        this.redisUtils.expire(key, timeout, TimeUnit.SECONDS);
    }

    public Object getObject(String key) {
        return this.redisUtils.getCacheObject(key);
    }

    public void setObject(String key, Object object, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        if (timeout == -1L) {
            this.redisUtils.setCacheObject(key, object);
        } else {
            this.redisUtils.setCacheObject(key, object, timeout, TimeUnit.SECONDS);
        }
    }

    public void updateObject(String key, Object object) {
        long expire = this.getObjectTimeout(key);
        if (expire == -2L) {
            return;
        }
        this.setObject(key, object, expire);
    }

    public void deleteObject(String key) {
        this.redisUtils.deleteObject(key);
    }

    public long getObjectTimeout(String key) {
        return this.redisUtils.getTimeToLive(key) / 1000L;
    }

    public void updateObjectTimeout(String key, long timeout) {
        if (timeout == -1L) {
            long expire = this.getObjectTimeout(key);
            if (expire != -1L) {
                this.setObject(key, this.getObject(key), timeout);
            }
            return;
        }
        this.redisUtils.expire(key, timeout, TimeUnit.SECONDS);
    }

    public List<String> searchData(String prefix, String keyword, int start, int size) {
        Collection<String> keys = this.redisUtils.keys(prefix + "*" + keyword + "*");
        ArrayList<String> list = new ArrayList<String>(keys);
        return SaFoxUtil.searchList(list, (int)start, (int)size);
    }
}

