package com.icetech.token.config;

import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.jwt.StpLogicJwtForStyle;
import cn.dev33.satoken.stp.StpInterface;
import cn.dev33.satoken.stp.StpLogic;
import com.icetech.token.core.dao.PlusSaTokenAloneRedisDao;
import com.icetech.token.core.dao.PlusSaTokenDao;
import com.icetech.token.core.service.SaInterfaceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

/**
 * Sa-Token 配置
 *
 * @author wgy
 */
@Configuration
public class SaTokenConfiguration {
    @Autowired
    private Environment environment;
    @Bean
    public StpLogic getStpLogicJwt() {
        return new StpLogicJwtForStyle();
    }

    @Bean
    public StpInterface stpInterface() {
        return new SaInterfaceImpl();
    }

    @Bean
    public SaTokenDao saTokenDao() {
        // 如果配置文件不包含相关配置，则不进行任何操作
        if(environment.getProperty(SaAloneRedisInject.ALONE_PREFIX + ".host") == null) {
            return new PlusSaTokenDao();
        }else {
            return new PlusSaTokenAloneRedisDao();
        }
    }

}
