/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.token.core.dao;

import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.util.SaFoxUtil;
import com.icetech.redis.utils.RedisUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlusSaTokenDao
implements SaTokenDao {
    private static final Logger log = LoggerFactory.getLogger(PlusSaTokenDao.class);

    public String get(String key) {
        log.info("\u83b7\u53d6token\u503c key {}", (Object)key);
        String value = (String)RedisUtils.getCacheObject((String)key);
        log.info("\u83b7\u53d6token\u503c value {}", (Object)value);
        return value;
    }

    public void set(String key, String value, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        if (timeout == -1L) {
            RedisUtils.setCacheObject((String)key, (Object)value);
        } else {
            RedisUtils.setCacheObject((String)key, (Object)value, (long)timeout, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    public void update(String key, String value) {
        long expire = this.getTimeout(key);
        if (expire == -2L) {
            return;
        }
        this.set(key, value, expire);
    }

    public void delete(String key) {
        RedisUtils.deleteObject((String)key);
    }

    public long getTimeout(String key) {
        return RedisUtils.getTimeToLive((String)key) / 1000L;
    }

    public void updateTimeout(String key, long timeout) {
        if (timeout == -1L) {
            long expire = this.getTimeout(key);
            if (expire != -1L) {
                this.set(key, this.get(key), timeout);
            }
            return;
        }
        RedisUtils.expire((String)key, (long)timeout, (TimeUnit)TimeUnit.SECONDS);
    }

    public Object getObject(String key) {
        return RedisUtils.getCacheObject((String)key);
    }

    public void setObject(String key, Object object, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        if (timeout == -1L) {
            RedisUtils.setCacheObject((String)key, (Object)object);
        } else {
            RedisUtils.setCacheObject((String)key, (Object)object, (long)timeout, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    public void updateObject(String key, Object object) {
        long expire = this.getObjectTimeout(key);
        if (expire == -2L) {
            return;
        }
        this.setObject(key, object, expire);
    }

    public void deleteObject(String key) {
        RedisUtils.deleteObject((String)key);
    }

    public long getObjectTimeout(String key) {
        return RedisUtils.getTimeToLive((String)key) / 1000L;
    }

    public void updateObjectTimeout(String key, long timeout) {
        if (timeout == -1L) {
            long expire = this.getObjectTimeout(key);
            if (expire != -1L) {
                this.setObject(key, this.getObject(key), timeout);
            }
            return;
        }
        RedisUtils.expire((String)key, (long)timeout, (TimeUnit)TimeUnit.SECONDS);
    }

    public List<String> searchData(String prefix, String keyword, int start, int size) {
        Collection keys = RedisUtils.keys((String)(prefix + "*" + keyword + "*"));
        ArrayList list = new ArrayList(keys);
        return SaFoxUtil.searchList(list, (int)start, (int)size);
    }
}

