package com.icetech.token.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.icetech.token.constants.CacheConstants;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.*;

/**
 * 用户信息
 *
 * @author wgy
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class LoginUser implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 账号id
     */
    private Long accountId;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 部门ID
     */
    private Long deptId;

    /**
     * 部门名
     */
    private String deptName;

    /**
     * 用户唯一标识
     */
    private String token;

    /**
     * 平台类型
     */
    private String platformType;

    /**
     * username:系统用户名密码, mobile：手机号验证码, wx_mini_app：微信小程序, wx_h5: 微信h5 
     */
    private String accountType;

    /**
     * 用户类型
     */
    private String userType;

    /**
     * 登录时间
     */
    private Long loginTime;

    /**
     * 过期时间
     */
    private Long expireTime;

    /**
     * 登录IP地址
     */
    private String ipaddr;

    /**
     * 登录地点
     */
    private String loginLocation;

    /**
     * 浏览器类型
     */
    private String browser;

    /**
     * 操作系统
     */
    private String os;

    /**
     * 菜单权限
     */
    private Set<String> menuPermission = new HashSet<>();

    /**
     * 角色权限
     */
    private Set<String> rolePermission = new HashSet<>();

    /**
     * 用户名
     */
    private String username;

    /**
     * 密码
     */
    @JsonIgnore
    private String password;

    /**
     * 角色对象
     */
    private List<RoleDTO> roles = new ArrayList<>();

    /**
     * 数据权限 当前角色ID
     */
    private Long roleId;

    /**
     * 租户id
     */
    private Long tenantId;

    /**
     * 手机号
     */
    private String mobile;


    /**
     * 昵称
     */
    private String nickName;

    /**
     * 真实姓
     */
    private String realName;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 扩展参数
     */
    private Map<String, Object> extensionMap = new HashMap<>();

    /**
     * 获取登录id
     */
    public String getLoginId() {
        return userType + CacheConstants.LOGINID_JOIN_CODE + accountId;
    }

}
