package com.icetech.token.core.service;

import cn.dev33.satoken.stp.StpInterface;
import com.icetech.token.enums.UserType;
import com.icetech.token.model.LoginUser;
import com.icetech.token.utils.LoginHelper;

import java.util.ArrayList;
import java.util.List;

/**
 * 权限认证接口实现
 *
 * @author wgy
 */
public class SaInterfaceImpl implements StpInterface {

    @Override
    public List<String> getPermissionList(Object loginId, String loginType) {
        LoginUser loginUser = LoginHelper.getLoginUser();
        UserType userType = UserType.getUserType(loginUser.getUserType());
        if (userType == UserType.SYS_USER) {
            return new ArrayList<>(loginUser.getMenuPermission());
        } else if (userType == UserType.APP_USER) {
            // app端权限返回 自行根据业务编写
        }
        return new ArrayList<>();
    }

    @Override
    public List<String> getRoleList(Object loginId, String loginType) {
        LoginUser loginUser = LoginHelper.getLoginUser();
        UserType userType = UserType.getUserType(loginUser.getUserType());
        if (userType == UserType.SYS_USER) {
            return new ArrayList<>(loginUser.getRolePermission());
        } else if (userType == UserType.APP_USER) {
            // app端权限返回 自行根据业务编写
        }
        return new ArrayList<>();
    }
}
