/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.rocketmq.core.strategy;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.icetech.rocketmq.annotation.CommonMessage;
import com.icetech.rocketmq.core.producer.MessageSendType;
import com.icetech.rocketmq.core.utils.ApplicationContextUtils;
import org.springframework.context.ApplicationContext;

public class SendMessageStrategy {
    private SendMessageStrategy() {
    }

    public static void send(CommonMessage commonMessage, Producer producer, Message message, ApplicationContext applicationContext) {
        if (commonMessage.messageSendType().equals((Object)MessageSendType.SEND)) {
            producer.send(message);
            return;
        }
        if (commonMessage.messageSendType().equals((Object)MessageSendType.SEND_ASYNC)) {
            producer.sendAsync(message, ApplicationContextUtils.getSendCallback(applicationContext, commonMessage.callback()));
            return;
        }
        if (commonMessage.messageSendType().equals((Object)MessageSendType.SEND_ONE_WAY)) {
            producer.sendOneway(message);
        }
    }
}

