/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.rocketmq.core.strategy;

import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.order.OrderProducer;
import com.aliyun.openservices.ons.api.transaction.TransactionProducer;
import com.icetech.rocketmq.annotation.CommonMessage;
import com.icetech.rocketmq.annotation.OrderMessage;
import com.icetech.rocketmq.annotation.RocketMessage;
import com.icetech.rocketmq.annotation.TransactionMessage;
import com.icetech.rocketmq.core.factory.ProducerConsumerFactory;
import com.icetech.rocketmq.core.factory.SendMessageFactory;
import com.icetech.rocketmq.error.RocketException;
import java.util.Map;
import org.springframework.context.ApplicationContext;

public class ProducerStrategy {
    private ProducerStrategy() {
    }

    public static void statsSendMessage(Long startDeliverTime, Map<String, Object> consumerContainer, RocketMessage rocketMessage, Object message, byte[] bytes, ApplicationContext applicationContex) throws RocketException {
        if (message instanceof CommonMessage) {
            CommonMessage commonMessage = (CommonMessage)message;
            Producer producer = ProducerConsumerFactory.getProducer(consumerContainer, rocketMessage, commonMessage);
            SendMessageFactory.sendMessage(startDeliverTime, producer, commonMessage, bytes, applicationContex);
            return;
        }
        if (message instanceof OrderMessage) {
            OrderMessage orderMessage = (OrderMessage)message;
            OrderProducer orderProducer = ProducerConsumerFactory.getProducer(consumerContainer, rocketMessage, orderMessage);
            SendMessageFactory.sendMessage(orderProducer, orderMessage, bytes);
            return;
        }
        if (message instanceof TransactionMessage) {
            TransactionMessage transactionMessage = (TransactionMessage)message;
            TransactionProducer transactionProducer = ProducerConsumerFactory.getProducer(consumerContainer, rocketMessage, transactionMessage);
            SendMessageFactory.sendMessage(transactionProducer, transactionMessage, bytes, applicationContex);
        }
    }
}

