/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.rocketmq.core.consumer;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.order.ConsumeOrderContext;
import com.aliyun.openservices.ons.api.order.MessageOrderListener;
import com.aliyun.openservices.ons.api.order.OrderAction;
import com.icetech.rocketmq.core.consumer.AbstractRocketListener;
import com.icetech.rocketmq.core.factory.execution.MethodFactoryExecution;
import com.icetech.rocketmq.error.RocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMessageOrderListener
extends AbstractRocketListener
implements MessageOrderListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultMessageOrderListener.class);

    public DefaultMessageOrderListener(MethodFactoryExecution methodFactoryExecution) {
        super(methodFactoryExecution);
    }

    public OrderAction consume(Message message, ConsumeOrderContext context) {
        log.info(">>>> Order message:{}>>>>", (Object)message);
        try {
            super.getMethodFactoryExecution().methodExecution(message.getBody());
        }
        catch (RocketException e) {
            super.printErrorLog();
            return OrderAction.Suspend;
        }
        return OrderAction.Success;
    }
}

