/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.rocketmq.core.strategy;

import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.order.OrderProducer;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionChecker;
import com.aliyun.openservices.ons.api.transaction.TransactionProducer;
import com.icetech.rocketmq.annotation.CommonMessage;
import com.icetech.rocketmq.annotation.OrderMessage;
import com.icetech.rocketmq.annotation.RocketMessage;
import com.icetech.rocketmq.annotation.TransactionMessage;
import com.icetech.rocketmq.autoconfigure.RocketProperties;
import com.icetech.rocketmq.core.factory.ProducerConsumerFactory;
import com.icetech.rocketmq.core.factory.ProducerFactory;
import com.icetech.rocketmq.core.factory.ThreadPoolFactory;
import com.icetech.rocketmq.core.utils.ApplicationContextUtils;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.context.ApplicationContext;

public class PutProducerStrategy {
    private PutProducerStrategy() {
    }

    public static void putProducer(Map<String, Object> producerConsumer, RocketMessage rocketMessage, Object bean, RocketProperties rocketProperties, ApplicationContext applicationContext) {
        if (bean instanceof CommonMessage) {
            CommonMessage commonMessage = (CommonMessage)bean;
            String producerConsumerKey = ProducerConsumerFactory.getProducerConsumerKey(rocketMessage, commonMessage);
            Producer producer = ProducerFactory.createProducer(rocketMessage, rocketProperties);
            ThreadPoolExecutor callbackThreadPoolExecutor = ThreadPoolFactory.createCallbackThreadPoolExecutor(rocketProperties);
            producer.start();
            producer.setCallbackExecutor((ExecutorService)callbackThreadPoolExecutor);
            producerConsumer.put(producerConsumerKey, producer);
            return;
        }
        if (bean instanceof OrderMessage) {
            OrderMessage orderMessage = (OrderMessage)bean;
            String producerConsumerKey = ProducerConsumerFactory.getProducerConsumerKey(rocketMessage, orderMessage);
            OrderProducer orderProducer = ProducerFactory.createOrderProducer(rocketMessage, rocketProperties);
            orderProducer.start();
            producerConsumer.put(producerConsumerKey, orderProducer);
            return;
        }
        if (bean instanceof TransactionMessage) {
            TransactionMessage transactionMessage = (TransactionMessage)bean;
            String producerConsumerKey = ProducerConsumerFactory.getProducerConsumerKey(rocketMessage, transactionMessage);
            LocalTransactionChecker localTransactionChecker = ApplicationContextUtils.getLocalTransactionChecker(applicationContext, transactionMessage.transactionStatus(), transactionMessage.checker());
            TransactionProducer transactionProducer = ProducerFactory.createTransactionProducer(rocketMessage, rocketProperties, localTransactionChecker);
            transactionProducer.start();
            producerConsumer.put(producerConsumerKey, transactionProducer);
        }
    }
}

