/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.rocketmq.core.consumer;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.batch.BatchMessageListener;
import com.icetech.rocketmq.core.consumer.AbstractRocketListener;
import com.icetech.rocketmq.core.factory.execution.MethodFactoryExecution;
import com.icetech.rocketmq.error.RocketException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBatchMessageListener
extends AbstractRocketListener
implements BatchMessageListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultBatchMessageListener.class);

    public DefaultBatchMessageListener(MethodFactoryExecution methodFactoryExecution) {
        super(methodFactoryExecution);
    }

    public Action consume(List<Message> messages, ConsumeContext context) {
        log.info(">>>>messageList:{}>>>>", messages);
        try {
            for (Message message : messages) {
                super.getMethodFactoryExecution().methodExecution(message.getBody());
            }
        }
        catch (RocketException e) {
            super.printErrorLog();
            return Action.ReconsumeLater;
        }
        return Action.CommitMessage;
    }
}

