/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.rocketmq.core.factory.execution;

import com.icetech.rocketmq.core.factory.MethodFactory;
import com.icetech.rocketmq.core.serializer.RocketSerializer;
import com.icetech.rocketmq.error.RocketException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodFactoryExecution {
    private static final Logger log = LoggerFactory.getLogger(MethodFactoryExecution.class);
    private Object bean;
    private Method method;
    private RocketSerializer rocketSerializer;

    public MethodFactoryExecution(Object bean, Method method, RocketSerializer rocketSerializer) {
        this.bean = bean;
        this.method = method;
        this.rocketSerializer = rocketSerializer;
    }

    public void methodExecution(byte[] message) throws RocketException {
        try {
            Class<?> methodParameter = MethodFactory.getMethodParameter(this.method);
            Object methodParameterBean = this.rocketSerializer.deSerialize(message, methodParameter);
            this.method.invoke(this.bean, methodParameterBean);
        }
        catch (Exception e) {
            throw new RocketException(e);
        }
    }

    public Object getBean() {
        return this.bean;
    }

    public Method getMethod() {
        return this.method;
    }

    public RocketSerializer getRocketSerializer() {
        return this.rocketSerializer;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setRocketSerializer(RocketSerializer rocketSerializer) {
        this.rocketSerializer = rocketSerializer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodFactoryExecution)) {
            return false;
        }
        MethodFactoryExecution other = (MethodFactoryExecution)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$bean = this.getBean();
        Object other$bean = other.getBean();
        if (this$bean == null ? other$bean != null : !this$bean.equals(other$bean)) {
            return false;
        }
        Method this$method = this.getMethod();
        Method other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
            return false;
        }
        RocketSerializer this$rocketSerializer = this.getRocketSerializer();
        RocketSerializer other$rocketSerializer = other.getRocketSerializer();
        return !(this$rocketSerializer == null ? other$rocketSerializer != null : !this$rocketSerializer.equals(other$rocketSerializer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MethodFactoryExecution;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $bean = this.getBean();
        result = result * 59 + ($bean == null ? 43 : $bean.hashCode());
        Method $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
        RocketSerializer $rocketSerializer = this.getRocketSerializer();
        result = result * 59 + ($rocketSerializer == null ? 43 : $rocketSerializer.hashCode());
        return result;
    }

    public String toString() {
        return "MethodFactoryExecution(bean=" + this.getBean() + ", method=" + this.getMethod() + ", rocketSerializer=" + this.getRocketSerializer() + ")";
    }
}

