/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.rocketmq.core.factory;

import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.order.OrderProducer;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionChecker;
import com.aliyun.openservices.ons.api.transaction.TransactionProducer;
import com.icetech.rocketmq.annotation.RocketMessage;
import com.icetech.rocketmq.autoconfigure.RocketProperties;
import com.icetech.rocketmq.core.factory.ProducerPropertiesFactory;
import java.util.Properties;

public class ProducerFactory {
    private ProducerFactory() {
    }

    public static Producer createProducer(RocketMessage rocketMessage, RocketProperties rocketProperties) {
        Properties properties = ProducerPropertiesFactory.createProducerProperties(rocketMessage, rocketProperties);
        return ONSFactory.createProducer((Properties)properties);
    }

    public static OrderProducer createOrderProducer(RocketMessage rocketMessage, RocketProperties rocketProperties) {
        Properties properties = ProducerPropertiesFactory.createProducerProperties(rocketMessage, rocketProperties);
        return ONSFactory.createOrderProducer((Properties)properties);
    }

    public static TransactionProducer createTransactionProducer(RocketMessage rocketMessage, RocketProperties rocketProperties, LocalTransactionChecker localTransactionChecker) {
        Properties properties = ProducerPropertiesFactory.createProducerProperties(rocketMessage, rocketProperties);
        properties.put("CheckImmunityTimeInSeconds", rocketProperties.getCheckImmunityTimeInSeconds());
        return ONSFactory.createTransactionProducer((Properties)properties, (LocalTransactionChecker)localTransactionChecker);
    }
}

