/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.rocketmq.container;

import com.icetech.rocketmq.annotation.RocketMessage;
import com.icetech.rocketmq.autoconfigure.RocketProperties;
import com.icetech.rocketmq.core.factory.ThreadPoolFactory;
import com.icetech.rocketmq.core.strategy.RocketConsumerStrategy;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class RocketProducerContainer
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private RocketProperties rocketProperties;
    private Map<String, Object> consumerContainer;

    public RocketProducerContainer(Map<String, Object> consumerContainer, RocketProperties rocketProperties) {
        this.consumerContainer = consumerContainer;
        this.rocketProperties = rocketProperties;
    }

    @PostConstruct
    public void initialize() {
        ThreadPoolExecutor threadPoolExecutor = ThreadPoolFactory.createProducerThreadPoolExecutor(this.rocketProperties);
        this.applicationContext.getBeansWithAnnotation(RocketMessage.class).forEach((beanName, bean) -> RocketConsumerStrategy.putProducer(threadPoolExecutor, this.consumerContainer, bean, this.rocketProperties, this.applicationContext));
        threadPoolExecutor.shutdown();
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

