/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.rocketmq.aspect;

import com.icetech.rocketmq.annotation.CommonMessage;
import com.icetech.rocketmq.annotation.OrderMessage;
import com.icetech.rocketmq.annotation.RocketMessage;
import com.icetech.rocketmq.annotation.TransactionMessage;
import com.icetech.rocketmq.autoconfigure.RocketProperties;
import com.icetech.rocketmq.core.factory.StartDeliverTimeFactory;
import com.icetech.rocketmq.core.factory.ThreadPoolFactory;
import com.icetech.rocketmq.core.utils.AspectUtils;
import com.icetech.rocketmq.core.utils.InterceptRocket;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nonnull;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@Aspect
public class RocketAspect
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(RocketAspect.class);
    private Map<String, Object> consumerContainer;
    private RocketProperties rocketProperties;
    private ThreadPoolExecutor threadPoolExecutor;
    private ApplicationContext applicationContext;

    public RocketAspect(Map<String, Object> consumerContainer, RocketProperties rocketProperties) {
        this.consumerContainer = consumerContainer;
        this.rocketProperties = rocketProperties;
        this.threadPoolExecutor = ThreadPoolFactory.createSendMessageThreadPoolExecutor(rocketProperties);
    }

    @Pointcut(value="@annotation(com.icetech.rocketmq.annotation.CommonMessage)")
    public void commonMessagePointcut() {
        log.debug("Start sending CommonMessage");
    }

    @Pointcut(value="@annotation(com.icetech.rocketmq.annotation.OrderMessage)")
    public void orderMessagePointcut() {
        log.debug("Start sending OrderMessage");
    }

    @Pointcut(value="@annotation(com.icetech.rocketmq.annotation.TransactionMessage)")
    public void transactionMessagePointcut() {
        log.debug("Start sending TransactionMessage");
    }

    @Around(value="commonMessagePointcut()")
    public Object rockerMessageSend(ProceedingJoinPoint point) throws Throwable {
        return InterceptRocket.intercept(StartDeliverTimeFactory.getStartDeliverTime(point.getArgs(), AspectUtils.getParams(point)), AspectUtils.getDeclaringClassAnnotation(point, RocketMessage.class), AspectUtils.getAnnotation(point, CommonMessage.class), point.proceed(), this.consumerContainer, this.threadPoolExecutor, this.applicationContext);
    }

    @Around(value="orderMessagePointcut()")
    public Object orderMessageSend(ProceedingJoinPoint point) throws Throwable {
        return InterceptRocket.intercept(StartDeliverTimeFactory.getStartDeliverTime(point.getArgs(), AspectUtils.getParams(point)), AspectUtils.getDeclaringClassAnnotation(point, RocketMessage.class), AspectUtils.getAnnotation(point, OrderMessage.class), point.proceed(), this.consumerContainer, this.threadPoolExecutor, this.applicationContext);
    }

    @Around(value="transactionMessagePointcut()")
    public Object transactionMessageSend(ProceedingJoinPoint point) throws Throwable {
        return InterceptRocket.intercept(StartDeliverTimeFactory.getStartDeliverTime(point.getArgs(), AspectUtils.getParams(point)), AspectUtils.getDeclaringClassAnnotation(point, RocketMessage.class), AspectUtils.getAnnotation(point, TransactionMessage.class), point.proceed(), this.consumerContainer, this.threadPoolExecutor, this.applicationContext);
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Map<String, Object> getConsumerContainer() {
        return this.consumerContainer;
    }

    public RocketProperties getRocketProperties() {
        return this.rocketProperties;
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setConsumerContainer(Map<String, Object> consumerContainer) {
        this.consumerContainer = consumerContainer;
    }

    public void setRocketProperties(RocketProperties rocketProperties) {
        this.rocketProperties = rocketProperties;
    }

    public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RocketAspect)) {
            return false;
        }
        RocketAspect other = (RocketAspect)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Object> this$consumerContainer = this.getConsumerContainer();
        Map<String, Object> other$consumerContainer = other.getConsumerContainer();
        if (this$consumerContainer == null ? other$consumerContainer != null : !((Object)this$consumerContainer).equals(other$consumerContainer)) {
            return false;
        }
        RocketProperties this$rocketProperties = this.getRocketProperties();
        RocketProperties other$rocketProperties = other.getRocketProperties();
        if (this$rocketProperties == null ? other$rocketProperties != null : !((Object)this$rocketProperties).equals(other$rocketProperties)) {
            return false;
        }
        ThreadPoolExecutor this$threadPoolExecutor = this.getThreadPoolExecutor();
        ThreadPoolExecutor other$threadPoolExecutor = other.getThreadPoolExecutor();
        if (this$threadPoolExecutor == null ? other$threadPoolExecutor != null : !this$threadPoolExecutor.equals(other$threadPoolExecutor)) {
            return false;
        }
        ApplicationContext this$applicationContext = this.getApplicationContext();
        ApplicationContext other$applicationContext = other.getApplicationContext();
        return !(this$applicationContext == null ? other$applicationContext != null : !this$applicationContext.equals(other$applicationContext));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RocketAspect;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $consumerContainer = this.getConsumerContainer();
        result = result * 59 + ($consumerContainer == null ? 43 : ((Object)$consumerContainer).hashCode());
        RocketProperties $rocketProperties = this.getRocketProperties();
        result = result * 59 + ($rocketProperties == null ? 43 : ((Object)$rocketProperties).hashCode());
        ThreadPoolExecutor $threadPoolExecutor = this.getThreadPoolExecutor();
        result = result * 59 + ($threadPoolExecutor == null ? 43 : $threadPoolExecutor.hashCode());
        ApplicationContext $applicationContext = this.getApplicationContext();
        result = result * 59 + ($applicationContext == null ? 43 : $applicationContext.hashCode());
        return result;
    }

    public String toString() {
        return "RocketAspect(consumerContainer=" + this.getConsumerContainer() + ", rocketProperties=" + this.getRocketProperties() + ", threadPoolExecutor=" + this.getThreadPoolExecutor() + ", applicationContext=" + this.getApplicationContext() + ")";
    }
}

