/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.redis.lock;

import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.StringUtils;
import com.icetech.redis.lock.RedissonDistributedLock;
import com.icetech.redis.lock.anno.RedisLock;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@Aspect
public class RedisLockAspect {
    private static final Logger log = LoggerFactory.getLogger(RedisLockAspect.class);
    @Resource
    private RedissonDistributedLock redissonDistributedLock;
    private final SpelExpressionParser spelExpressionParser = new SpelExpressionParser();
    private final DefaultParameterNameDiscoverer nameDiscoverer = new DefaultParameterNameDiscoverer();

    @Pointcut(value="@annotation(com.icetech.redis.lock.anno.RedisLock)")
    public void redisLockAspect() {
    }

    @Around(value="redisLockAspect()")
    public Object lockAroundAction(ProceedingJoinPoint joinPoint) throws Throwable {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method targetMethod = methodSignature.getMethod();
        RedisLock annotation = targetMethod.getAnnotation(RedisLock.class);
        if (Objects.isNull(annotation)) {
            return joinPoint.proceed(joinPoint.getArgs());
        }
        String lockKey = annotation.lockKey();
        if (StringUtils.isEmpty((CharSequence)lockKey)) {
            throw new RuntimeException("\u5206\u5e03\u5f0f\u9501key \u672a\u8bbe\u7f6e");
        }
        if (lockKey.contains("#")) {
            Object[] args = joinPoint.getArgs();
            lockKey = this.getValBySpEL(annotation.lockKey(), methodSignature, args);
        }
        return this.redissonDistributedLock.locked(() -> {
            try {
                return joinPoint.proceed(joinPoint.getArgs());
            }
            catch (Throwable e) {
                if (e instanceof ResponseBodyException) {
                    throw (ResponseBodyException)e;
                }
                throw new RuntimeException(e);
            }
        }, lockKey, annotation.lockWaitTime(), annotation.lockLeaseTime());
    }

    private String getValBySpEL(String spEL, MethodSignature methodSignature, Object[] args) {
        String[] paramNames = this.nameDiscoverer.getParameterNames(methodSignature.getMethod());
        if (paramNames != null && paramNames.length > 0) {
            Expression expression = this.spelExpressionParser.parseExpression(spEL);
            StandardEvaluationContext context = new StandardEvaluationContext();
            for (int i = 0; i < args.length; ++i) {
                context.setVariable(paramNames[i], args[i]);
            }
            return expression.getValue((EvaluationContext)context).toString();
        }
        return null;
    }
}

