/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.redis.config;

import com.icetech.redis.config.RedissonAutoConfigurationCustomizer;
import com.icetech.redis.config.RedissonProperties;
import com.icetech.redis.lock.RedisLockAspect;
import com.icetech.redis.lock.RedissonDistributedLock;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.api.RedissonReactiveClient;
import org.redisson.api.RedissonRxClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.util.ReflectionUtils;

@Configuration
@ConditionalOnClass(value={Redisson.class, RedisOperations.class})
@ConditionalOnProperty(prefix="spring.redis.redisson", name={"enable"}, havingValue="true", matchIfMissing=true)
@AutoConfigureBefore(value={RedisAutoConfiguration.class})
@EnableConfigurationProperties(value={RedissonProperties.class, RedisProperties.class})
public class RedissonConfiguration {
    private static final String REDIS_PROTOCOL_PREFIX = "redis://";
    private static final String REDISS_PROTOCOL_PREFIX = "rediss://";
    @Autowired(required=false)
    private List<RedissonAutoConfigurationCustomizer> redissonAutoConfigurationCustomizers;
    @Autowired
    private RedissonProperties redissonProperties;
    @Autowired
    private RedisProperties redisProperties;
    @Autowired
    private ApplicationContext ctx;

    @Bean
    public RedisLockAspect redisLockAspect() {
        return new RedisLockAspect();
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean(value={RedissonReactiveClient.class})
    public RedissonReactiveClient redissonReactive(RedissonClient redisson) {
        return redisson.reactive();
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean(value={RedissonRxClient.class})
    public RedissonRxClient redissonRxJava(RedissonClient redisson) {
        return redisson.rxJava();
    }

    @Bean
    @ConditionalOnMissingBean(value={RedissonDistributedLock.class})
    public RedissonDistributedLock redissonDistributedLock(RedissonClient redisson) {
        return new RedissonDistributedLock(redisson);
    }

    @Bean(destroyMethod="shutdown")
    @ConditionalOnMissingBean(value={RedissonClient.class})
    public RedissonClient redisson() throws IOException {
        int timeout;
        Config config = null;
        Method clusterMethod = ReflectionUtils.findMethod(RedisProperties.class, (String)"getCluster");
        Method timeoutMethod = ReflectionUtils.findMethod(RedisProperties.class, (String)"getTimeout");
        Object timeoutValue = ReflectionUtils.invokeMethod((Method)timeoutMethod, (Object)this.redisProperties);
        if (null == timeoutValue) {
            timeout = 10000;
        } else if (!(timeoutValue instanceof Integer)) {
            Method millisMethod = ReflectionUtils.findMethod(timeoutValue.getClass(), (String)"toMillis");
            timeout = ((Long)ReflectionUtils.invokeMethod((Method)millisMethod, (Object)timeoutValue)).intValue();
        } else {
            timeout = (Integer)timeoutValue;
        }
        if (this.redissonProperties.getConfig() != null) {
            try {
                config = Config.fromYAML((String)this.redissonProperties.getConfig());
            }
            catch (IOException e) {
                try {
                    config = Config.fromJSON((String)this.redissonProperties.getConfig());
                }
                catch (IOException e1) {
                    throw new IllegalArgumentException("Can't parse config", e1);
                }
            }
        } else if (this.redissonProperties.getFile() != null) {
            try {
                InputStream is = this.getConfigStream();
                config = Config.fromYAML((InputStream)is);
            }
            catch (IOException e) {
                try {
                    InputStream is = this.getConfigStream();
                    config = Config.fromJSON((InputStream)is);
                }
                catch (IOException e1) {
                    throw new IllegalArgumentException("Can't parse config", e1);
                }
            }
        } else if (this.redisProperties.getSentinel() != null) {
            Method nodesMethod = ReflectionUtils.findMethod(RedisProperties.Sentinel.class, (String)"getNodes");
            Object nodesValue = ReflectionUtils.invokeMethod((Method)nodesMethod, (Object)this.redisProperties.getSentinel());
            String[] nodes = nodesValue instanceof String ? this.convert(Arrays.asList(((String)nodesValue).split(","))) : this.convert((List)nodesValue);
            config = new Config();
            ((SentinelServersConfig)config.useSentinelServers().setMasterName(this.redisProperties.getSentinel().getMaster()).addSentinelAddress(nodes).setDatabase(this.redisProperties.getDatabase()).setConnectTimeout(timeout)).setPassword(this.redisProperties.getPassword());
        } else if (clusterMethod != null && ReflectionUtils.invokeMethod((Method)clusterMethod, (Object)this.redisProperties) != null) {
            Object clusterObject = ReflectionUtils.invokeMethod((Method)clusterMethod, (Object)this.redisProperties);
            Method nodesMethod = ReflectionUtils.findMethod(clusterObject.getClass(), (String)"getNodes");
            List nodesObject = (List)ReflectionUtils.invokeMethod((Method)nodesMethod, (Object)clusterObject);
            String[] nodes = this.convert(nodesObject);
            config = new Config();
            ((ClusterServersConfig)config.useClusterServers().addNodeAddress(nodes).setConnectTimeout(timeout)).setPassword(this.redisProperties.getPassword());
        } else {
            config = new Config();
            String prefix = REDIS_PROTOCOL_PREFIX;
            Method method = ReflectionUtils.findMethod(RedisProperties.class, (String)"isSsl");
            if (method != null && ((Boolean)ReflectionUtils.invokeMethod((Method)method, (Object)this.redisProperties)).booleanValue()) {
                prefix = REDISS_PROTOCOL_PREFIX;
            }
            ((SingleServerConfig)config.useSingleServer().setAddress(prefix + this.redisProperties.getHost() + ":" + this.redisProperties.getPort()).setConnectTimeout(timeout)).setDatabase(this.redisProperties.getDatabase()).setPassword(this.redisProperties.getPassword());
        }
        if (this.redissonAutoConfigurationCustomizers != null) {
            for (RedissonAutoConfigurationCustomizer customizer : this.redissonAutoConfigurationCustomizers) {
                customizer.customize(config);
            }
        }
        config.setCodec((Codec)JsonJacksonCodec.INSTANCE);
        return Redisson.create((Config)config);
    }

    private String[] convert(List<String> nodesObject) {
        ArrayList<String> nodes = new ArrayList<String>(nodesObject.size());
        for (String node : nodesObject) {
            if (!node.startsWith(REDIS_PROTOCOL_PREFIX) && !node.startsWith(REDISS_PROTOCOL_PREFIX)) {
                nodes.add(REDIS_PROTOCOL_PREFIX + node);
                continue;
            }
            nodes.add(node);
        }
        return nodes.toArray(new String[nodes.size()]);
    }

    private InputStream getConfigStream() throws IOException {
        Resource resource = this.ctx.getResource(this.redissonProperties.getFile());
        InputStream is = resource.getInputStream();
        return is;
    }
}

