/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.redis.handle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.map.SingletonMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisHandle {
    private static final Logger log = LoggerFactory.getLogger(RedisHandle.class);
    private RedisTemplate<Object, Object> redisTemplate;
    private StringRedisTemplate stringRedisTemplate;

    public <T> T cacheObject(String cacheKey, Class<T> clazz, Supplier<T> supplier, long expireMillis) {
        return (T)this.cacheValue(cacheKey, value -> JSONObject.parseObject((String)value, (Class)clazz), supplier, JSON::toJSONString, expireMillis);
    }

    public <T> T cacheObject(String cacheKey, TypeReference<T> reference, Supplier<T> supplier, long expireMillis) {
        return (T)this.cacheValue(cacheKey, value -> JSONObject.parseObject((String)value, (TypeReference)reference, (Feature[])new Feature[0]), supplier, JSON::toJSONString, expireMillis);
    }

    @Nonnull
    public <T> List<T> cacheList(String cacheKey, Class<T> clazz, Supplier<List<T>> supplier, long expireMillis) {
        List list = this.cacheValue(cacheKey, value -> JSONArray.parseArray((String)value, (Class)clazz), supplier, JSON::toJSONString, expireMillis);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    @Nonnull
    public <T> List<T> cacheList(String cacheKey, TypeReference<List<T>> reference, Supplier<List<T>> supplier, long expireMillis) {
        List list = this.cacheValue(cacheKey, value -> (List)JSONArray.parseObject((String)value, (TypeReference)reference, (Feature[])new Feature[0]), supplier, JSON::toJSONString, expireMillis);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public <T> T cacheValue(String cacheKey, Function<String, T> stringToValue, Supplier<T> supplier, Function<T, String> valueToString, long expireMillis) {
        String cacheValue = (String)this.stringRedisTemplate.opsForValue().get((Object)cacheKey);
        if (StringUtils.isNotBlank((CharSequence)cacheValue)) {
            if ("$NONE$".equals(cacheValue)) {
                return null;
            }
            String all = "ALL";
            if (cacheKey.startsWith("user:park:") && cacheValue.equals(all)) {
                cacheValue = "[-1]";
            }
            return stringToValue.apply(cacheValue);
        }
        if (supplier == null) {
            return null;
        }
        T data = supplier.get();
        if (data == null) {
            this.stringRedisTemplate.opsForValue().set((Object)cacheKey, (Object)"$NONE$", expireMillis, TimeUnit.MILLISECONDS);
            return null;
        }
        cacheValue = valueToString.apply(data);
        this.stringRedisTemplate.opsForValue().set((Object)cacheKey, (Object)cacheValue, expireMillis, TimeUnit.MILLISECONDS);
        return data;
    }

    public <T> T getObjectFromMap(String cacheKey, String mapKey, Class<T> clazz, Supplier<Map<String, T>> supplier, long expireMillis) {
        return (T)this.getValueFromMap(cacheKey, mapKey, value -> JSONObject.parseObject((String)value, (Class)clazz), JSON::toJSONString, supplier, expireMillis);
    }

    @Nonnull
    public <T> List<T> getListFromMap(String cacheKey, String mapKey, Class<T> clazz, Supplier<Map<String, List<T>>> supplier, long expireMillis) {
        List list = this.getValueFromMap(cacheKey, mapKey, value -> JSONArray.parseArray((String)value, (Class)clazz), JSON::toJSONString, supplier, expireMillis);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public <T> T getValueFromMap(String cacheKey, String mapKey, Function<String, T> stringToValue, Function<T, String> valueToString, Supplier<Map<String, T>> supplier, long expireMillis) {
        HashOperations operations = this.stringRedisTemplate.opsForHash();
        String cacheValue = (String)operations.get((Object)cacheKey, (Object)mapKey);
        if (StringUtils.isNotBlank((CharSequence)cacheValue)) {
            if ("$NONE$".equals(cacheValue)) {
                return null;
            }
            return stringToValue.apply(cacheValue);
        }
        Map map = this.cacheMap(cacheKey, Function.identity(), stringToValue, supplier, valueToString, expireMillis);
        return map.get(mapKey);
    }

    @Nonnull
    public <T> Map<String, T> cacheObjectMap(String cacheKey, Class<T> valueClass, Supplier<Map<String, T>> supplier, long expireMillis) {
        return this.cacheMap(cacheKey, Function.identity(), value -> JSONObject.parseObject((String)value, (Class)valueClass), supplier, JSON::toJSONString, expireMillis);
    }

    @Nonnull
    public <T> Map<String, T> cacheObjectMap(String cacheKey, TypeReference<T> reference, Supplier<Map<String, T>> supplier, long expireMillis) {
        return this.cacheMap(cacheKey, Function.identity(), value -> JSONObject.parseObject((String)value, (TypeReference)reference, (Feature[])new Feature[0]), supplier, JSON::toJSONString, expireMillis);
    }

    @Nonnull
    public <T> Map<String, List<T>> cacheListMap(String cacheKey, Class<T> valueClass, Supplier<Map<String, List<T>>> supplier, long expireMillis) {
        return this.cacheMap(cacheKey, Function.identity(), value -> JSONArray.parseArray((String)value, (Class)valueClass), supplier, JSON::toJSONString, expireMillis);
    }

    @Nonnull
    public <T> Map<String, List<T>> cacheListMap(String cacheKey, TypeReference<List<T>> reference, Supplier<Map<String, List<T>>> supplier, long expireMillis) {
        return this.cacheMap(cacheKey, Function.identity(), value -> (List)JSONArray.parseObject((String)value, (TypeReference)reference, (Feature[])new Feature[0]), supplier, JSON::toJSONString, expireMillis);
    }

    public <K, V> Map<K, V> cacheMap(String cacheKey, Function<String, K> keyFunction, Function<String, V> stringToValue, Supplier<Map<K, V>> supplier, Function<V, String> valueToString, long expireMillis) {
        HashOperations operations = this.stringRedisTemplate.opsForHash();
        HashMap<String, String> cacheMap = operations.entries((Object)cacheKey);
        if (MapUtils.isNotEmpty((Map)cacheMap)) {
            if (cacheMap.containsKey("$NONE$")) {
                return Collections.emptyMap();
            }
            HashMap<K, V> map = new HashMap<K, V>(cacheMap.size());
            for (Map.Entry cacheEntry : cacheMap.entrySet()) {
                K key = keyFunction.apply((String)cacheEntry.getKey());
                if (StringUtils.isBlank((CharSequence)((CharSequence)cacheEntry.getValue())) || "$NONE$".equals(cacheEntry.getValue())) {
                    map.put(key, null);
                    continue;
                }
                map.put(key, stringToValue.apply((String)cacheEntry.getValue()));
            }
            return map;
        }
        if (supplier == null) {
            return Collections.emptyMap();
        }
        Map<K, V> map = supplier.get();
        if (MapUtils.isEmpty(map)) {
            cacheMap = new SingletonMap((Object)"$NONE$", (Object)"$NONE$");
            map = Collections.emptyMap();
        } else {
            cacheMap = new HashMap<String, String>(map.size());
            for (Map.Entry<K, V> entry : map.entrySet()) {
                cacheMap.put(entry.getKey().toString(), entry.getValue() == null ? "$NONE$" : valueToString.apply(entry.getValue()));
            }
        }
        this.stringRedisTemplate.opsForHash().putAll((Object)cacheKey, cacheMap);
        this.stringRedisTemplate.expire((Object)cacheKey, expireMillis, TimeUnit.MILLISECONDS);
        return map;
    }

    public Boolean delete(String key) {
        return this.redisTemplate.delete((Object)key);
    }

    public RedisHandle(RedisTemplate<Object, Object> redisTemplate, StringRedisTemplate stringRedisTemplate) {
        this.redisTemplate = redisTemplate;
        this.stringRedisTemplate = stringRedisTemplate;
    }
}

