package com.icetech.mq;

/**
 * @author wanggy 
 */
public class CorrelationData extends org.springframework.amqp.rabbit.connection.CorrelationData {
	
	/**
	 * 消息体
	 */
	private volatile Object message;

	/**
	 * 交换机名称
	 */
	private String exchange;

	/**
	 * 路由key
	 */
	private String routingKey;

	/**
	 * 重试次数
	 */
	private int retryCount = 0;

	public CorrelationData(String id) {
		super(id);
	}

	public CorrelationData(String id, Object data, String exchange, String routingKey) {
		this(id);
		this.message = data;
		this.exchange = exchange;
		this.routingKey = routingKey;
	}

	public Object getMessage() {
		return message;
	}

	public void setMessage(Object message) {
		this.message = message;
	}

	public int getRetryCount() {
		return retryCount;
	}

	public void setRetryCount(int retryCount) {
		this.retryCount = retryCount;
	}

	public String getExchange() {
		return exchange;
	}

	public void setExchange(String exchange) {
		this.exchange = exchange;
	}

	public String getRoutingKey() {
		return routingKey;
	}

	public void setRoutingKey(String routingKey) {
		this.routingKey = routingKey;
	}
}
