package com.icetech.mq.config;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;

/**
 * 多mq 配置属性
 *
 * @author wgy
 */
@ConfigurationProperties(prefix = "spring.rabbitmq.multiple")
public class RabbitMultipleProperties {


    /**
     * 多mq 配置
     */
    private List<RabbitPropertiesExtend> mqs;

    public List<RabbitPropertiesExtend> getMqs() {
        return mqs;
    }

    public void setMqs(List<RabbitPropertiesExtend> mqs) {
        this.mqs = mqs;
    }

    @Getter
    @Setter
    @ToString
    public static final class RabbitPropertiesExtend extends RabbitProperties {

        /**
         * 扩展mq 的名字
         */
        private String mqName;
        /**
         * 使用独立的发布者Rabbit连接发布消息
         */
        protected boolean usePublisherConnection = true;
    }
}
