package com.icetech.mq.config;

import lombok.Data;

import java.io.Serializable;
import java.util.Objects;

/**
 * Description: 中间队列 消息实体
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved.
 *
 * @version 1.0 2018年07月03日 11:06 by 王广宇（wanggy@cloud-young.com）创建
 */
@Data
public class DelayBean implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 消息id
     */
    private String correlationId;

    /**
     * 发送mq名称
     */
    private String mqName;

    /**
     * 交换机
     */
    private String exchange;

    /**
     * 路由
     */
    private String routing;

    /**
     * 本消息延迟总时间
     */
    private Long delay;

    /**
     * 剩余延迟时间
     */
    private Long surplusDelay;

    /**
     * 消息实体
     */
    private Object msg;

    /**
     * 对象class name
     */
    private String className;

    public DelayBean() {

    }

    public DelayBean(String correlationId, String mqName, String exchange, String routing, Long delay, Object msg) {
        this.correlationId = correlationId;
        this.mqName = mqName;
        this.exchange = exchange;
        this.routing = routing;
        this.delay = delay;
        this.surplusDelay = delay - Integer.MAX_VALUE;
        this.msg = msg;
        this.className = Objects.nonNull(msg) ? msg.getClass().getName() : "java.lang.String";
    }
}
