/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.oss.impl;

import com.icetech.oss.OSSProperties;
import com.icetech.oss.impl.BaseOssService;
import io.minio.DownloadObjectArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.UploadObjectArgs;
import io.minio.http.Method;
import java.io.File;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioOssService
extends BaseOssService<MinioClient> {
    private static final Logger log = LoggerFactory.getLogger(MinioOssService.class);

    @Override
    public boolean isExistFile(String fileName, String bucketName) {
        try {
            StatObjectResponse response = ((MinioClient)this.internalOssClient).statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucketName)).object(fileName)).build());
            return response != null;
        }
        catch (Exception e) {
            log.error("OSS\u6587\u4ef6\u662f\u5426\u5b58\u5728\u83b7\u53d6\u5931\u8d25|{}|{}", new Object[]{bucketName, fileName, e});
            return false;
        }
    }

    @Override
    public String buildImageUrl(String bucketName, String fileName) {
        return this.ossProperties.getEndpoint() + (fileName.startsWith("/") ? fileName : "/" + fileName);
    }

    @Override
    public String getImageUrl(String bucketName, String name, Long expireSec) {
        return this.getImageUrl((MinioClient)this.publicOssClient, bucketName, name, expireSec);
    }

    @Override
    public String getInternalImageUrl(String name, String bucketName, Long expireSec) {
        return this.getImageUrl((MinioClient)this.internalOssClient, bucketName, name, expireSec);
    }

    public String getImageUrl(MinioClient minioClient, String bucketName, String name, Long expireSec) {
        try {
            if (expireSec == null || expireSec < 1L) {
                expireSec = this.ossProperties.getDefaultExpireSeconds();
            }
            String url = minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(bucketName)).object(name)).method(Method.GET).expiry(expireSec.intValue(), TimeUnit.SECONDS).build());
            return url;
        }
        catch (Exception e) {
            log.error("OSS\u6587\u4ef6\u751f\u6210\u8bbf\u95ee\u5730\u5740\u5931\u8d25|{}|{}|{}", new Object[]{bucketName, name, expireSec, e});
            return null;
        }
    }

    public GetObjectResponse getOSS2InputStream(String name, String bucketName) {
        try {
            return ((MinioClient)this.internalOssClient).getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(name)).build());
        }
        catch (Exception e) {
            log.error("OSS\u6587\u4ef6\u83b7\u53d6\u4e0b\u8f7d\u6d41\u5931\u8d25|{}|{}", new Object[]{bucketName, name, e});
            return null;
        }
    }

    @Override
    public boolean getOSS2File(String fileName, String bucketName, File stored) {
        try {
            if (stored.exists() && !stored.delete()) {
                log.warn("OSS\u6587\u4ef6\u4e0b\u8f7d\u5b58\u50a8\u5931\u8d25, \u672c\u5730\u6587\u4ef6\u5df2\u5b58\u5728\u4e14\u5220\u9664\u5931\u8d25|{}|{}|{}", new Object[]{bucketName, fileName, stored.getPath()});
                return false;
            }
            ((MinioClient)this.internalOssClient).downloadObject((DownloadObjectArgs)((DownloadObjectArgs.Builder)((DownloadObjectArgs.Builder)DownloadObjectArgs.builder().bucket(bucketName)).object(fileName)).filename(stored.getPath()).build());
            log.info("OSS\u6587\u4ef6\u4e0b\u8f7d\u5b58\u50a8\u6210\u529f|{}|{}|{}", new Object[]{bucketName, fileName, stored.getPath()});
            return true;
        }
        catch (Exception e) {
            log.error("OSS\u6587\u4ef6\u4e0b\u8f7d\u5b58\u50a8\u5931\u8d25|{}|{}|{}", new Object[]{bucketName, fileName, stored.getPath(), e});
            return false;
        }
    }

    @Override
    public boolean uploadFile(File file, String fileName, String bucketName) {
        try {
            ObjectWriteResponse response = ((MinioClient)this.internalOssClient).uploadObject((UploadObjectArgs)((UploadObjectArgs.Builder)((UploadObjectArgs.Builder)UploadObjectArgs.builder().bucket(bucketName)).object(fileName)).filename(file.getPath()).build());
            log.info("OSS\u6587\u4ef6\u4e0a\u4f20\u6210\u529f|{}|{}|{}|{}|{}", new Object[]{file.getPath(), bucketName, fileName, response.etag(), response.versionId()});
            return true;
        }
        catch (Exception e) {
            log.error("OSS\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25|{}|{}|{}", new Object[]{file.getPath(), bucketName, fileName, e});
            return false;
        }
    }

    @Override
    public boolean uploadFile(InputStream inputStream, String fileName, String bucketName) {
        try {
            ObjectWriteResponse response = ((MinioClient)this.internalOssClient).putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(fileName)).stream(inputStream, -1L, 0x140000000L).build());
            log.info("OSS\u8f93\u5165\u6d41\u4e0a\u4f20\u6210\u529f|{}|{}|{}|{}", new Object[]{bucketName, fileName, response.etag(), response.versionId()});
            return true;
        }
        catch (Exception e) {
            log.error("OSS\u8f93\u5165\u6d41\u4e0a\u4f20\u5931\u8d25|{}|{}", new Object[]{bucketName, fileName, e});
            return false;
        }
    }

    public MinioOssService(OSSProperties ossProperties) {
        super(ossProperties, MinioClient.builder().endpoint(ossProperties.getEndpoint()).credentials(ossProperties.getAccessKeyId(), ossProperties.getAccessKeySecret()).build(), MinioClient.builder().endpoint(ossProperties.getInternalEndpoint()).credentials(ossProperties.getAccessKeyId(), ossProperties.getAccessKeySecret()).build());
    }
}

