/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.oss.impl;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.HttpMethod;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.icetech.oss.OSSProperties;
import com.icetech.oss.impl.BaseOssService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.Instant;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CtyunOssService
extends BaseOssService<AmazonS3> {
    private static final Logger log = LoggerFactory.getLogger(CtyunOssService.class);

    @Override
    public boolean isExistFile(String fileName, String bucketName) {
        try {
            InputStream oss2InputStream = this.getOSS2InputStream(fileName, bucketName);
            return oss2InputStream != null;
        }
        catch (Exception e) {
            log.error("OSS\u6587\u4ef6\u662f\u5426\u5b58\u5728\u83b7\u53d6\u5931\u8d25|{}|{}", new Object[]{bucketName, fileName, e});
            return false;
        }
    }

    @Override
    public String buildImageUrl(String bucketName, String fileName) {
        return this.getImageUrl(bucketName, fileName, 3600L);
    }

    @Override
    public String getInternalImageUrl(String name, String bucketName, Long expireSec) {
        return this.getImageUrl(bucketName, name, expireSec);
    }

    @Override
    public String getImageUrl(String bucketName, String name, Long expireSec) {
        try {
            if (expireSec == null || expireSec < 1L) {
                expireSec = this.ossProperties.getDefaultExpireSeconds();
            }
            GeneratePresignedUrlRequest var = new GeneratePresignedUrlRequest(bucketName, name);
            Date expiration = new Date();
            long expTimeMillis = Instant.now().toEpochMilli();
            expiration.setTime(expTimeMillis += 1000L * expireSec);
            var.setExpiration(expiration);
            var.setMethod(HttpMethod.GET);
            URL url = ((AmazonS3)this.publicOssClient).generatePresignedUrl(var);
            return url.toString().replaceAll("^http://", "https://");
        }
        catch (Exception e) {
            log.error("OSS\u6587\u4ef6\u751f\u6210\u8bbf\u95ee\u5730\u5740\u5931\u8d25|{}|{}|{}", new Object[]{bucketName, name, expireSec, e});
            return null;
        }
    }

    @Override
    public InputStream getOSS2InputStream(String name, String bucketName) {
        try {
            GetObjectRequest request = new GetObjectRequest(bucketName, name);
            S3Object result = ((AmazonS3)this.publicOssClient).getObject(request);
            return result.getObjectContent();
        }
        catch (Exception e) {
            log.error("OSS\u6587\u4ef6\u83b7\u53d6\u4e0b\u8f7d\u6d41\u5931\u8d25|{}|{}", new Object[]{bucketName, name, e});
            return null;
        }
    }

    @Override
    public boolean getOSS2File(String fileName, String bucketName, File stored) {
        try {
            if (stored.exists() && !stored.delete()) {
                log.warn("OSS\u6587\u4ef6\u4e0b\u8f7d\u5b58\u50a8\u5931\u8d25, \u672c\u5730\u6587\u4ef6\u5df2\u5b58\u5728\u4e14\u5220\u9664\u5931\u8d25|{}|{}|{}", new Object[]{bucketName, fileName, stored.getPath()});
                return false;
            }
            GetObjectRequest request = new GetObjectRequest(bucketName, fileName);
            S3Object result = ((AmazonS3)this.publicOssClient).getObject(request);
            try (S3ObjectInputStream in = result.getObjectContent();
                 FileOutputStream outputStream = new FileOutputStream(stored);){
                byte[] readBuf = new byte[0x100000];
                int readLen = 0;
                while ((readLen = in.read(readBuf)) > 0) {
                    outputStream.write(readBuf, 0, readLen);
                }
            }
            catch (IOException e) {
                log.warn("OSS\u6587\u4ef6\u4e0b\u8f7d\u5b58\u50a8\u51fa\u9519|{}|{}|{}", new Object[]{bucketName, fileName, stored.getPath(), e});
            }
            log.info("OSS\u6587\u4ef6\u4e0b\u8f7d\u5b58\u50a8\u6210\u529f|{}|{}|{}", new Object[]{bucketName, fileName, stored.getPath()});
            return true;
        }
        catch (Exception e) {
            log.error("OSS\u6587\u4ef6\u4e0b\u8f7d\u5b58\u50a8\u5931\u8d25|{}|{}|{}", new Object[]{bucketName, fileName, stored.getPath(), e});
            return false;
        }
    }

    @Override
    public boolean uploadFile(File file, String fileName, String bucketName) {
        try {
            PutObjectRequest request = new PutObjectRequest(bucketName, fileName, file);
            PutObjectResult putObjectResult = ((AmazonS3)this.publicOssClient).putObject(request);
            log.info("OSS\u6587\u4ef6\u4e0a\u4f20\u6210\u529f|{}|{}|{}|{}|{}", new Object[]{file.getPath(), bucketName, fileName, putObjectResult.getETag(), putObjectResult.getVersionId()});
            return true;
        }
        catch (Exception e) {
            log.error("OSS\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25|{}|{}|{}", new Object[]{file.getPath(), bucketName, fileName, e});
            return false;
        }
    }

    @Override
    public boolean uploadFile(InputStream inputStream, String fileName, String bucketName) {
        try {
            PutObjectRequest request = new PutObjectRequest(bucketName, fileName, inputStream, null);
            PutObjectResult putObjectResult = ((AmazonS3)this.publicOssClient).putObject(request);
            log.info("OSS\u8f93\u5165\u6d41\u4e0a\u4f20\u6210\u529f|{}|{}|{}|{}", new Object[]{bucketName, fileName, putObjectResult.getETag(), putObjectResult.getVersionId()});
            return true;
        }
        catch (Exception e) {
            log.error("OSS\u8f93\u5165\u6d41\u4e0a\u4f20\u5931\u8d25|{}|{}", new Object[]{bucketName, fileName, e});
            return false;
        }
    }

    public CtyunOssService(OSSProperties ossProperties) {
        super(ossProperties, properties -> {
            BasicAWSCredentials credentials = new BasicAWSCredentials(ossProperties.getAccessKeyId(), ossProperties.getAccessKeySecret());
            ClientConfiguration awsClientConfig = new ClientConfiguration();
            awsClientConfig.setSignerOverride("AWSS3V4SignerType");
            awsClientConfig.setProtocol(Protocol.HTTP);
            return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials))).withClientConfiguration(awsClientConfig)).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(ossProperties.getEndpoint(), ""))).disableChunkedEncoding()).enablePathStyleAccess()).build();
        }, properties -> {
            BasicAWSCredentials credentials = new BasicAWSCredentials(ossProperties.getAccessKeyId(), ossProperties.getAccessKeySecret());
            ClientConfiguration awsClientConfig = new ClientConfiguration();
            awsClientConfig.setSignerOverride("AWSS3V4SignerType");
            awsClientConfig.setProtocol(Protocol.HTTP);
            return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials))).withClientConfiguration(awsClientConfig)).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(ossProperties.getEndpoint(), ""))).disableChunkedEncoding()).enablePathStyleAccess()).build();
        });
        log.info("ctyun OSS\u5ba2\u6237\u7aef\u521d\u59cb\u5316\u6210\u529f|{}|{}|{}", new Object[]{ossProperties.getEndpoint(), ossProperties.getInternalEndpoint(), ossProperties.getBucketName()});
    }
}

