/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.oss.impl;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.S3ClientOptions;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.icetech.oss.OSSProperties;
import com.icetech.oss.impl.BaseOssService;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonS3OssService
extends BaseOssService<AmazonS3Client> {
    private static final Logger log = LoggerFactory.getLogger(AmazonS3OssService.class);

    @Override
    public boolean isExistFile(String fileName, String bucketName) {
        try {
            return ((AmazonS3Client)this.internalOssClient).doesObjectExist(bucketName, fileName);
        }
        catch (Exception e) {
            log.error("[oss\u5f02\u5e38]e", (Throwable)e);
            return false;
        }
    }

    @Override
    public String buildImageUrl(String bucketName, String fileName) {
        return null;
    }

    @Override
    public String getImageUrl(String bucketName, String name, Long expireSec) {
        try {
            Date expiration = new Date(System.currentTimeMillis() + expireSec * 1000L);
            URL url = ((AmazonS3Client)this.publicOssClient).generatePresignedUrl(bucketName, name, expiration);
            return url.toString().replace("http://", "https://");
        }
        catch (Exception e) {
            log.error("[oss\u5f02\u5e38]e", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getInternalImageUrl(String name, String bucketName, Long expireSec) {
        try {
            Date expiration = new Date(System.currentTimeMillis() + expireSec * 1000L);
            URL url = ((AmazonS3Client)this.internalOssClient).generatePresignedUrl(bucketName, name, expiration);
            return url.toString().replace("http://", "https://");
        }
        catch (Exception e) {
            log.error("[oss\u5f02\u5e38]e", (Throwable)e);
            return null;
        }
    }

    @Override
    public InputStream getOSS2InputStream(String name, String bucketName) {
        try {
            S3Object ossObj = ((AmazonS3Client)this.internalOssClient).getObject(this.ossProperties.getBucketName(), name);
            return ossObj == null ? null : ossObj.getObjectContent();
        }
        catch (Exception e) {
            log.error("[oss\u5f02\u5e38]e", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean getOSS2File(String fileName, String bucketName, File file) {
        try {
            ((AmazonS3Client)this.internalOssClient).getObject(new GetObjectRequest(bucketName, fileName), file);
            return true;
        }
        catch (Exception e) {
            log.error("[oss\u5f02\u5e38]e", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean uploadFile(File file, String fileName, String bucketName) {
        try {
            PutObjectResult result = ((AmazonS3Client)this.internalOssClient).putObject(bucketName, fileName, file);
            log.info("OSS\u6587\u4ef6\u4e0a\u4f20\u6210\u529f|{}|{}|{}|{}|{}", new Object[]{file.getPath(), bucketName, fileName, result.getETag(), result.getVersionId()});
            return true;
        }
        catch (Exception e) {
            log.error("OSS\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25|{}|{}|{}", new Object[]{file.getPath(), bucketName, fileName, e});
            return false;
        }
    }

    @Override
    public boolean uploadFile(InputStream inputStream, String fileName, String bucketName) {
        try {
            PutObjectResult result = ((AmazonS3Client)this.internalOssClient).putObject(bucketName, fileName, inputStream, this.buildMateDate(inputStream.available()));
            log.info("OSS\u8f93\u5165\u6d41\u4e0a\u4f20\u6210\u529f|{}|{}|{}|{}", new Object[]{bucketName, fileName, result.getETag(), result.getVersionId()});
            return true;
        }
        catch (Exception e) {
            log.error("OSS\u8f93\u5165\u6d41\u4e0a\u4f20\u5931\u8d25|{}|{}", new Object[]{bucketName, fileName, e});
            return false;
        }
    }

    private ObjectMetadata buildMateDate(long size) {
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(size);
        metadata.setContentType("image/jpeg");
        return metadata;
    }

    public AmazonS3OssService(OSSProperties ossProperties) {
        super(ossProperties, properties -> {
            BasicAWSCredentials basicAwsCred = new BasicAWSCredentials(ossProperties.getAccessKeyId(), ossProperties.getAccessKeySecret());
            ClientConfiguration clientConfiguration = new ClientConfiguration();
            clientConfiguration.setProtocol(Protocol.valueOf((String)ossProperties.getProtocol()));
            AmazonS3Client client = new AmazonS3Client((AWSCredentials)basicAwsCred, clientConfiguration);
            S3ClientOptions options = S3ClientOptions.builder().setPathStyleAccess(true).setPayloadSigningEnabled(true).disableChunkedEncoding().build();
            client.setS3ClientOptions(options);
            client.setEndpoint(ossProperties.getEndpoint());
            return client;
        }, properties -> {
            BasicAWSCredentials basicAwsCred = new BasicAWSCredentials(ossProperties.getAccessKeyId(), ossProperties.getAccessKeySecret());
            ClientConfiguration clientConfiguration = new ClientConfiguration();
            clientConfiguration.setProtocol(Protocol.valueOf((String)ossProperties.getInternalProtocol()));
            AmazonS3Client client = new AmazonS3Client((AWSCredentials)basicAwsCred, clientConfiguration);
            S3ClientOptions options = S3ClientOptions.builder().setPathStyleAccess(true).setPayloadSigningEnabled(true).disableChunkedEncoding().build();
            client.setS3ClientOptions(options);
            client.setEndpoint(ossProperties.getInternalEndpoint());
            return client;
        });
    }
}

