/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.oss.impl;

import com.aliyun.oss.ClientBuilderConfiguration;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.PutObjectResult;
import com.icetech.oss.OSSProperties;
import com.icetech.oss.impl.BaseOssService;
import com.icetech.oss.io.OSSObjectInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunOssService
extends BaseOssService<OSS> {
    private static final Logger log = LoggerFactory.getLogger(AliyunOssService.class);

    @Override
    public boolean isExistFile(String fileName, String bucketName) {
        try {
            return ((OSS)this.internalOssClient).doesObjectExist(bucketName, fileName);
        }
        catch (Exception e) {
            log.error("OSS\u6587\u4ef6\u662f\u5426\u5b58\u5728\u83b7\u53d6\u5931\u8d25|{}|{}", new Object[]{bucketName, fileName, e});
            return false;
        }
    }

    @Override
    public String buildImageUrl(String bucketName, String fileName) {
        return "http://" + this.ossProperties.getBucketName() + "." + this.ossProperties.getEndpoint() + (fileName.startsWith("/") ? fileName : "/" + fileName);
    }

    @Override
    public String getImageUrl(String bucketName, String name, Long expireSec) {
        return this.getImageUrl((OSS)this.publicOssClient, bucketName, name, expireSec);
    }

    @Override
    public String getInternalImageUrl(String name, String bucketName, Long expireSec) {
        return this.getImageUrl((OSS)this.internalOssClient, bucketName, name, expireSec);
    }

    public String getImageUrl(OSS ossClient, String bucketName, String name, Long expireSec) {
        try {
            if (expireSec == null || expireSec < 1L) {
                expireSec = this.ossProperties.getDefaultExpireSeconds();
            }
            Date expiration = new Date(System.currentTimeMillis() + expireSec * 1000L);
            URL url = ossClient.generatePresignedUrl(bucketName, name, expiration);
            return url.toString().replace("http://", "https://");
        }
        catch (Exception e) {
            log.error("OSS\u6587\u4ef6\u751f\u6210\u8bbf\u95ee\u5730\u5740\u5931\u8d25|{}|{}|{}", new Object[]{bucketName, name, expireSec, e});
            return null;
        }
    }

    @Override
    public InputStream getOSS2InputStream(String name, String bucketName) {
        try {
            OSSObject ossObj = ((OSS)this.internalOssClient).getObject(bucketName, name);
            if (ossObj == null || ossObj.getObjectContent() == null) {
                log.warn("OSS\u6587\u4ef6\u83b7\u53d6\u4e0b\u8f7d\u6d41\u83b7\u53d6\u4e3a\u7a7a|{}|{}", (Object)bucketName, (Object)name);
                return null;
            }
            return new OSSObjectInputStream(ossObj);
        }
        catch (Exception e) {
            log.error("OSS\u6587\u4ef6\u83b7\u53d6\u4e0b\u8f7d\u6d41\u5931\u8d25|{}|{}", new Object[]{bucketName, name, e});
            return null;
        }
    }

    @Override
    public boolean getOSS2File(String fileName, String bucketName, File stored) {
        try {
            ((OSS)this.internalOssClient).getObject(new GetObjectRequest(bucketName, fileName), stored);
            log.info("OSS\u6587\u4ef6\u4e0b\u8f7d\u5b58\u50a8\u6210\u529f|{}|{}|{}", new Object[]{bucketName, fileName, stored.getPath()});
            return true;
        }
        catch (Exception e) {
            log.error("OSS\u6587\u4ef6\u4e0b\u8f7d\u5b58\u50a8\u5931\u8d25|{}|{}|{}", new Object[]{bucketName, fileName, stored.getPath(), e});
            return false;
        }
    }

    @Override
    public boolean uploadFile(File file, String fileName, String bucketName) {
        try {
            PutObjectResult result = ((OSS)this.internalOssClient).putObject(bucketName, fileName, file);
            log.info("OSS\u6587\u4ef6\u4e0a\u4f20\u6210\u529f|{}|{}|{}|{}|{}", new Object[]{file.getPath(), bucketName, fileName, result.getETag(), result.getVersionId()});
            return true;
        }
        catch (Exception e) {
            log.error("OSS\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25|{}|{}|{}", new Object[]{file.getPath(), bucketName, fileName, e});
            return false;
        }
    }

    @Override
    public boolean uploadFile(InputStream inputStream, String fileName, String bucketName) {
        try {
            PutObjectResult result = ((OSS)this.internalOssClient).putObject(bucketName, fileName, inputStream);
            log.info("OSS\u6587\u4ef6\u4e0a\u4f20\u6210\u529f|{}|{}|{}|{}", new Object[]{bucketName, fileName, result.getETag(), result.getVersionId()});
            return true;
        }
        catch (Exception e) {
            log.error("[oss\u5f02\u5e38]e", (Throwable)e);
            return false;
        }
    }

    public AliyunOssService(OSSProperties ossProperties, ClientBuilderConfiguration clientBuilderConfiguration) {
        super(ossProperties, new OSSClientBuilder().build(ossProperties.getEndpoint(), ossProperties.getAccessKeyId(), ossProperties.getAccessKeySecret(), clientBuilderConfiguration), new OSSClientBuilder().build(ossProperties.getInternalEndpoint(), ossProperties.getAccessKeyId(), ossProperties.getAccessKeySecret(), clientBuilderConfiguration));
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            ((OSS)this.publicOssClient).shutdown();
            ((OSS)this.internalOssClient).shutdown();
        }));
    }
}

