/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.oss.impl;

import com.icetech.common.utils.StringUtils;
import com.icetech.oss.OSSProperties;
import com.icetech.oss.OssService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Base64;
import java.util.function.Function;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOssService<T>
implements OssService {
    private static final Logger log = LoggerFactory.getLogger(BaseOssService.class);
    protected final OSSProperties ossProperties;
    protected final String tempPath;
    protected final T publicOssClient;
    protected final T internalOssClient;

    @Override
    public boolean isExistFile(String fileName) {
        return this.isExistFile(fileName, this.ossProperties.getBucketName());
    }

    @Override
    public String buildImageUrl(String fileName) {
        return this.buildImageUrl(this.ossProperties.getBucketName(), fileName);
    }

    @Override
    public String getImageUrl(String name) {
        return this.getImageUrlTime(name, this.ossProperties.getDefaultExpireSeconds());
    }

    @Override
    public String getImageUrlTime(String name, Long expireSec) {
        return this.getImageUrl(this.ossProperties.getBucketName(), name, expireSec);
    }

    @Override
    public String getImageUrl(String name, String bucketName) {
        return this.getImageUrl(bucketName, name, this.ossProperties.getDefaultExpireSeconds());
    }

    @Override
    public String getInternalImageUrl(String name) {
        return this.getInternalImageUrl(name, this.ossProperties.getDefaultExpireSeconds());
    }

    @Override
    public String getInternalImageUrl(String name, Long expireSec) {
        return this.getInternalImageUrl(name, this.ossProperties.getBucketName(), expireSec);
    }

    @Override
    public InputStream getOSS2InputStream(String name) {
        return this.getOSS2InputStream(name, this.ossProperties.getBucketName());
    }

    @Override
    public File getOSS2File(String fileName) {
        return this.getOSS2File(fileName, this.ossProperties.getBucketName());
    }

    @Override
    public File getOSS2File(String fileName, String bucketName) {
        String saveName = FilenameUtils.getName((String)fileName);
        File stored = new File(this.tempPath + saveName);
        if (this.getOSS2File(fileName, bucketName, stored)) {
            return stored;
        }
        return null;
    }

    @Override
    public boolean uploadBase64(String base64, String fileName) {
        return this.uploadBase64(base64, fileName, this.ossProperties.getBucketName());
    }

    @Override
    public boolean uploadBase64(String base64, String fileName, String bucketName) {
        byte[] bytes = Base64.getDecoder().decode(base64);
        return this.uploadFileStream(bytes, fileName, bucketName);
    }

    @Override
    public boolean uploadFileStream(byte[] fileStream, String fileName) {
        return this.uploadFileStream(fileStream, fileName, this.ossProperties.getBucketName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean uploadFileStream(byte[] fileStream, String fileName, String bucketName) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(fileStream);){
            boolean bl = this.uploadFile(bais, fileName, bucketName);
            return bl;
        }
        catch (Exception e) {
            log.error("OSS\u670d\u52a1\u4e0a\u4f20\u6587\u4ef6\u5b57\u8282\u5931\u8d25|{}|{}", new Object[]{bucketName, fileName, e});
            return false;
        }
    }

    @Override
    public boolean uploadFile(File file, String fileName) {
        return this.uploadFile(file, fileName, this.ossProperties.getBucketName());
    }

    @Override
    public boolean uploadFile(InputStream inputStream, String fileName) {
        return this.uploadFile(inputStream, fileName, this.ossProperties.getBucketName());
    }

    public BaseOssService(OSSProperties ossProperties, T publicOssClient, T internalOssClient) {
        this(ossProperties, prop -> publicOssClient, prop -> internalOssClient);
    }

    public BaseOssService(OSSProperties ossProperties, Function<OSSProperties, T> publicOssClient, Function<OSSProperties, T> internalOssClient) {
        this.ossProperties = ossProperties;
        String tempPath = StringUtils.isBlank((CharSequence)ossProperties.getDownPath()) ? System.getProperty("java.io.tmpdir") : ossProperties.getDownPath();
        File tempDir = new File(tempPath);
        if (!tempDir.exists() || tempDir.isFile()) {
            boolean mkdirs = tempDir.mkdirs();
            if (mkdirs) {
                log.info("\u521b\u5efa\u4e34\u65f6\u5b58\u50a8\u6587\u4ef6\u5939: " + tempPath);
            } else {
                throw new IllegalArgumentException("\u65e0\u6cd5\u521b\u5efa\u4e34\u65f6\u5b58\u50a8\u6587\u4ef6\u5939: " + tempPath);
            }
        }
        this.tempPath = tempDir.getPath() + File.separator;
        this.publicOssClient = publicOssClient.apply(ossProperties);
        this.internalOssClient = internalOssClient.apply(ossProperties);
        log.info("{} OSS\u5ba2\u6237\u7aef\u521d\u59cb\u5316\u6210\u529f|{}|{}|{}", new Object[]{ossProperties.getType(), ossProperties.getEndpoint(), ossProperties.getInternalEndpoint(), ossProperties.getBucketName()});
    }

    public OSSProperties getOssProperties() {
        return this.ossProperties;
    }

    public String getTempPath() {
        return this.tempPath;
    }

    public T getPublicOssClient() {
        return this.publicOssClient;
    }

    public T getInternalOssClient() {
        return this.internalOssClient;
    }
}

