/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.oss.config;

import com.aliyun.oss.ClientBuilderConfiguration;
import com.icetech.oss.OSSProperties;
import com.icetech.oss.OssService;
import com.icetech.oss.impl.AliyunOssService;
import com.icetech.oss.impl.AmazonS3OssService;
import com.icetech.oss.impl.CtyunOssService;
import com.icetech.oss.impl.MinioOssService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={OSSProperties.class})
public class OSSAutoConfiguration {
    @Bean
    @ConfigurationProperties(value="oss.client.aliyun")
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="oss", name={"type"}, havingValue="ALIYUN", matchIfMissing=true)
    public ClientBuilderConfiguration clientBuilderConfiguration() {
        ClientBuilderConfiguration configuration = new ClientBuilderConfiguration();
        configuration.setConnectionRequestTimeout(50000);
        return configuration;
    }

    @Bean
    @ConditionalOnProperty(prefix="oss", name={"type"}, havingValue="ALIYUN", matchIfMissing=true)
    public OssService aliyunOssService(OSSProperties ossProperties, ClientBuilderConfiguration clientBuilderConfiguration) {
        return new AliyunOssService(ossProperties, clientBuilderConfiguration);
    }

    @Bean
    @ConditionalOnProperty(prefix="oss", name={"type"}, havingValue="MINIO")
    public OssService minioOssService(OSSProperties ossProperties) {
        return new MinioOssService(ossProperties);
    }

    @Bean
    @ConditionalOnProperty(prefix="oss", name={"type"}, havingValue="AMAZON_S3")
    public AmazonS3OssService amazonS3OssService(OSSProperties ossProperties) {
        return new AmazonS3OssService(ossProperties);
    }

    @Bean
    @ConditionalOnProperty(prefix="oss", name={"type"}, havingValue="CTYUN")
    public OssService ctyunOssService(OSSProperties ossProperties) {
        return new CtyunOssService(ossProperties);
    }
}

