package com.icetech.oss;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

@Data
@ConfigurationProperties(prefix = "oss")
public class OSSProperties {
    /**
     * 阿里云
     */
    public static final String OSS_TYPE_ALIYUN = "ALIYUN";
    /**
     * MINIO
     */
    public static final String OSS_TYPE_MINIO = "MINIO";
    /**
     * 亚马逊S3
     */
    public static final String OSS_TYPE_AMAZON_S3 = "AMAZON_S3";
    /**
     * 天翼云存储
     */
    public static final String OSS_TYPE_CTYUN = "CTYUN";

    private String type;
    private String endpoint;
    private String internalEndpoint;
    private String bucketName;
    private String accessKeyId;
    private String accessKeySecret;
    /**
     * 文件下载路径
     */
    private String downPath;
    private String protocol = "HTTPS";
    private String internalProtocol = "HTTPS";
    private long defaultExpireSeconds = 3600;
}
