package com.icetech.nacos;

import com.alibaba.nacos.client.constant.Constants;
import com.alibaba.nacos.client.env.NacosClientProperties;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

@Slf4j
public class NacosProjectNameInitializer implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    @Override
    public void initialize(ConfigurableApplicationContext applicationContext) {
        String projectName = NacosClientProperties.PROTOTYPE.getProperty(Constants.SysEnv.PROJECT_NAME);
        if (StringUtils.isNotBlank(projectName)) {
            if (log.isDebugEnabled()) log.debug("nacos客户端应用名已指定|${args/env:project.name:{}}", projectName);
            return;
        }

        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        if (resolveProjectName(environment, "project.name")) return;
        if (resolveProjectName(environment, "nacos.project-name")) return;
        if (resolveProjectName(environment, "nacos.project.name")) return;
        if (resolveProjectName(environment, "spring.nacos.project-name")) return;
        if (resolveProjectName(environment, "spring.nacos.project.name")) return;
        if (resolveProjectName(environment, "spring.cloud.nacos.project-name")) return;
        if (resolveProjectName(environment, "spring.cloud.nacos.project.name")) return;
        if (resolveProjectName(environment, "spring.application.name")) return;

        if (log.isDebugEnabled()) log.debug("nacos客户端未找到应用名配置");
    }

    private static boolean resolveProjectName(ConfigurableEnvironment environment, String propertyName) {
        String projectName = environment.getProperty(propertyName);
        if (StringUtils.isBlank(projectName)) return false;
        NacosClientProperties.PROTOTYPE.setProperty(Constants.SysEnv.PROJECT_NAME, projectName);
        if (log.isDebugEnabled()) log.debug("nacos客户端应用名配置|${spring:{}:{}}", propertyName, projectName);
        return true;
    }
}
