/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.nacos;

import com.alibaba.nacos.client.env.NacosClientProperties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public class NacosProjectNameInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Logger log = LoggerFactory.getLogger(NacosProjectNameInitializer.class);

    public void initialize(ConfigurableApplicationContext applicationContext) {
        String projectName = NacosClientProperties.PROTOTYPE.getProperty("project.name");
        if (StringUtils.isNotBlank((CharSequence)projectName)) {
            if (log.isDebugEnabled()) {
                log.debug("nacos\u5ba2\u6237\u7aef\u5e94\u7528\u540d\u5df2\u6307\u5b9a|${args/env:project.name:{}}", (Object)projectName);
            }
            return;
        }
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        if (NacosProjectNameInitializer.resolveProjectName(environment, "project.name")) {
            return;
        }
        if (NacosProjectNameInitializer.resolveProjectName(environment, "nacos.project-name")) {
            return;
        }
        if (NacosProjectNameInitializer.resolveProjectName(environment, "nacos.project.name")) {
            return;
        }
        if (NacosProjectNameInitializer.resolveProjectName(environment, "spring.nacos.project-name")) {
            return;
        }
        if (NacosProjectNameInitializer.resolveProjectName(environment, "spring.nacos.project.name")) {
            return;
        }
        if (NacosProjectNameInitializer.resolveProjectName(environment, "spring.cloud.nacos.project-name")) {
            return;
        }
        if (NacosProjectNameInitializer.resolveProjectName(environment, "spring.cloud.nacos.project.name")) {
            return;
        }
        if (NacosProjectNameInitializer.resolveProjectName(environment, "spring.application.name")) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("nacos\u5ba2\u6237\u7aef\u672a\u627e\u5230\u5e94\u7528\u540d\u914d\u7f6e");
        }
    }

    private static boolean resolveProjectName(ConfigurableEnvironment environment, String propertyName) {
        String projectName = environment.getProperty(propertyName);
        if (StringUtils.isBlank((CharSequence)projectName)) {
            return false;
        }
        NacosClientProperties.PROTOTYPE.setProperty("project.name", projectName);
        if (log.isDebugEnabled()) {
            log.debug("nacos\u5ba2\u6237\u7aef\u5e94\u7528\u540d\u914d\u7f6e|${spring:{}:{}}", (Object)propertyName, (Object)projectName);
        }
        return true;
    }
}

