/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.mqtt.subscriber;

import com.icetech.mqtt.annotation.NamedValue;
import com.icetech.mqtt.annotation.Payload;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;

final class ParameterModel {
    private static final Logger log = LoggerFactory.getLogger(ParameterModel.class);
    private boolean sign;
    private boolean required;
    private Class<?> type;
    private String name;
    private Object defaultValue;
    private LinkedList<Converter<Object, Object>> converters;

    private ParameterModel() {
    }

    public static LinkedList<ParameterModel> of(Method method) {
        LinkedList<ParameterModel> parameters = new LinkedList<ParameterModel>();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterTypes.length; ++i) {
            ParameterModel model = new ParameterModel();
            parameters.add(model);
            model.type = parameterTypes[i];
            model.defaultValue = ParameterModel.defaultValue(model.type);
            Annotation[] annotations = parameterAnnotations[i];
            if (annotations == null || annotations.length <= 0) continue;
            for (Annotation annotation : annotations) {
                if (annotation.annotationType() == NamedValue.class) {
                    NamedValue namedValue = (NamedValue)annotation;
                    model.required = model.required || namedValue.required();
                    model.name = namedValue.value();
                }
                if (annotation.annotationType() == Payload.class) {
                    Payload payload = (Payload)annotation;
                    model.sign = true;
                    model.required = model.required || payload.required();
                    model.converters = ParameterModel.toConverters(payload.value());
                }
                if (annotation.annotationType() != NonNull.class) continue;
                model.required = true;
            }
        }
        return parameters;
    }

    public static LinkedList<Converter<Object, Object>> toConverters(Class<? extends Converter<?, ?>>[] classes) {
        if (classes == null || classes.length == 0) {
            return null;
        }
        LinkedList<Converter<Object, Object>> converters = new LinkedList<Converter<Object, Object>>();
        for (Class<Converter<?, ?>> clazz : classes) {
            try {
                converters.add(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                log.error("Create converter instance failed.", (Throwable)e);
            }
        }
        return converters;
    }

    public boolean isSign() {
        return this.sign;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public LinkedList<Converter<Object, Object>> getConverters() {
        return this.converters;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    private static Object defaultValue(Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return false;
            }
            if (type == Character.TYPE) {
                return Character.valueOf('\u0000');
            }
            if (type == Byte.TYPE) {
                return (byte)0;
            }
            if (type == Short.TYPE) {
                return (short)0;
            }
            if (type == Integer.TYPE) {
                return 0;
            }
            if (type == Long.TYPE) {
                return 0L;
            }
            if (type == Float.TYPE) {
                return Float.valueOf(0.0f);
            }
            if (type == Double.TYPE) {
                return 0.0;
            }
        }
        return null;
    }
}

