/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.mqtt.autoconfigure;

import com.icetech.mqtt.autoconfigure.MqttAsyncClientAdapter;
import com.icetech.mqtt.autoconfigure.MqttConnectOptionsAdapter;
import com.icetech.mqtt.autoconfigure.MqttConnector;
import com.icetech.mqtt.autoconfigure.MqttConversionService;
import com.icetech.mqtt.autoconfigure.PayloadJacksonAutoConfiguration;
import com.icetech.mqtt.properties.MqttProperties;
import com.icetech.mqtt.publisher.MqttPublisher;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.ConverterRegistry;

@Order(value=1010)
@AutoConfigureAfter(value={PayloadJacksonAutoConfiguration.class})
@ConditionalOnClass(value={MqttAsyncClient.class})
@ConditionalOnProperty(prefix="mqtt", name={"disable"}, havingValue="false", matchIfMissing=true)
@EnableConfigurationProperties(value={MqttProperties.class})
@Configuration
public class MqttAutoConfiguration {
    public MqttAutoConfiguration(ListableBeanFactory beanFactory) {
        MqttConversionService.addBeans((ConverterRegistry)MqttConversionService.getSharedInstance(), beanFactory);
    }

    @Bean
    @Order(value=1010)
    @ConditionalOnMissingBean(value={MqttConnectOptionsAdapter.class})
    public MqttConnectOptionsAdapter mqttConnectOptionsAdapter() {
        return (clientId, options) -> {};
    }

    @Bean
    @Order(value=1010)
    @ConditionalOnMissingBean(value={MqttAsyncClientAdapter.class})
    public MqttAsyncClientAdapter mqttAsyncClientAdapter() {
        return (clientId, serverURI) -> new MqttAsyncClient(serverURI[0], clientId, (MqttClientPersistence)new MemoryPersistence());
    }

    @Bean
    @Order(value=1013)
    @ConditionalOnMissingBean(value={MqttPublisher.class})
    public MqttPublisher mqttPublisher(MqttProperties properties) {
        MqttPublisher mqttPublisher = new MqttPublisher();
        mqttPublisher.setProperties(properties);
        return mqttPublisher;
    }

    @Bean
    @Order
    public MqttConnector mqttConnector(MqttAsyncClientAdapter clientAdapter, MqttProperties properties, MqttConnectOptionsAdapter adapter) {
        MqttConnector connector = new MqttConnector();
        connector.start(clientAdapter, properties, adapter);
        return connector;
    }
}

