/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.log;

import ch.qos.logback.classic.pattern.MessageConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import com.icetech.log.SensitiveInfoUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SensitiveDataConverter
extends MessageConverter {
    private static String converterCanRun = "true";
    private static String sensitiveDataKeys = "accessToken,password,base64Str,payCode";
    private static Pattern pattern = Pattern.compile("[0-9a-zA-Z]");

    public String convert(ILoggingEvent event) {
        String oriLogMsg = event.getFormattedMessage();
        String afterLogMsg = this.invokeMsg(oriLogMsg);
        return afterLogMsg;
    }

    public String invokeMsg(String oriMsg) {
        String tempMsg = oriMsg;
        if ("true".equals(converterCanRun) && sensitiveDataKeys != null && sensitiveDataKeys.length() > 0) {
            String[] keysArray;
            for (String key : keysArray = sensitiveDataKeys.split(",")) {
                int index = -1;
                do {
                    if ((index = tempMsg.indexOf(key, index + 1)) == -1 || this.isWordChar(tempMsg, key, index)) continue;
                    int valueStart = this.getValueStartIndex(tempMsg, index + key.length());
                    int valueEnd = this.getValueEndEIndex(tempMsg, valueStart);
                    String subStr = tempMsg.substring(valueStart, valueEnd);
                    subStr = this.convertMsg(subStr, key);
                    tempMsg = tempMsg.substring(0, valueStart) + subStr + tempMsg.substring(valueEnd);
                } while (index != -1);
            }
        }
        return tempMsg;
    }

    private boolean isWordChar(String msg, String key, int index) {
        char preCh;
        Matcher match;
        if (index != 0 && (match = pattern.matcher((preCh = msg.charAt(index - 1)) + "")).matches()) {
            return true;
        }
        char nextCh = msg.charAt(index + key.length());
        match = pattern.matcher(nextCh + "");
        return match.matches();
    }

    private int getValueStartIndex(String msg, int valueStart) {
        while (true) {
            char ch;
            if ((ch = msg.charAt(valueStart)) == ':' || ch == '=') {
                if ((ch = msg.charAt(++valueStart)) != '\"') break;
                ++valueStart;
                break;
            }
            ++valueStart;
        }
        return valueStart;
    }

    private int getValueEndEIndex(String msg, int valueEnd) {
        while (valueEnd != msg.length()) {
            char ch = msg.charAt(valueEnd);
            if (ch == '\"') {
                if (valueEnd + 1 == msg.length()) break;
                char nextCh = msg.charAt(valueEnd + 1);
                if (nextCh == ';' || nextCh == ',') {
                    char preCh;
                    while (valueEnd > 0 && (preCh = msg.charAt(valueEnd - 1)) == '\\') {
                        --valueEnd;
                    }
                    break;
                }
                ++valueEnd;
                continue;
            }
            if (ch == ';' || ch == ',' || ch == '}') break;
            ++valueEnd;
        }
        return valueEnd;
    }

    private String convertMsg(String subMsg, String key) {
        if ("phone".equals(key)) {
            return SensitiveInfoUtils.mobilePhone(subMsg);
        }
        if ("accessToken".equals(key)) {
            return SensitiveInfoUtils.token(subMsg);
        }
        return "******";
    }

    public static void main(String[] args) {
        String tempMsg = "[device-p2p]|2021-08-02 18:30:38.253|XNIO-1 task-1|INFO |7c2fb0bbf6a0420ea2a857cc474ae183|com.icetech.rpc.trace.TraceIdFilter[55]|[client][SassUserApi.getCurrentWebUser]receive:[{\"accessToken\":\"32cc81b56bd54c19ae11b116e54999a4\"}]";
        String tempMsg1 = "{\"reason\":\"\u6210\u529f \",\"result\":{\"payCode\":\"JH2131171027170837443588J6\",\"realname\":\"\u674e\u54ea\u5a1c\",\"bankcard\":\"6226430106137525\",\"idcard\":\"130333198901192762\",\"mobile\":\"13210141605\",\"res\":\"1\",\"message\":\"\u9a8c\u8bc1\u6210\u529f\"},\"error_code\":0}";
        SensitiveDataConverter sc = new SensitiveDataConverter();
        System.out.println(sc.invokeMsg(tempMsg));
        System.out.println(sc.invokeMsg(tempMsg1));
    }
}

