/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.excel.listener;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.CellExtra;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadExtraDataListener<T>
extends AnalysisEventListener<T> {
    private static final Logger log = LoggerFactory.getLogger(UploadExtraDataListener.class);
    List<T> list = new ArrayList<T>();
    private final Integer headRowNumber;
    private final List<CellExtra> extraMergeInfoList = Lists.newArrayList();

    public UploadExtraDataListener(Integer headRowNumber) {
        this.headRowNumber = headRowNumber;
    }

    public void invoke(T data, AnalysisContext context) {
        log.debug("\u89e3\u6790\u5230\u4e00\u6761\u6570\u636e:{}", (Object)JSON.toJSONString(data));
        this.list.add(data);
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        log.info("\u6240\u6709\u6570\u636e\u89e3\u6790\u5b8c\u6210\uff01");
    }

    public List<T> getData() {
        return this.list;
    }

    public void extra(CellExtra extra, AnalysisContext context) {
        log.debug("\u8bfb\u53d6\u5230\u4e86\u4e00\u6761\u989d\u5916\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)extra));
        switch (extra.getType()) {
            case COMMENT: {
                log.debug("\u989d\u5916\u4fe1\u606f\u662f\u6279\u6ce8,\u5728rowIndex:{},columnIndex;{},\u5185\u5bb9\u662f:{}", new Object[]{extra.getRowIndex(), extra.getColumnIndex(), extra.getText()});
                break;
            }
            case HYPERLINK: {
                if ("Sheet1!A1".equals(extra.getText())) {
                    log.debug("\u989d\u5916\u4fe1\u606f\u662f\u8d85\u94fe\u63a5,\u5728rowIndex:{},columnIndex;{},\u5185\u5bb9\u662f:{}", new Object[]{extra.getRowIndex(), extra.getColumnIndex(), extra.getText()});
                    break;
                }
                if ("Sheet2!A1".equals(extra.getText())) {
                    log.debug("\u989d\u5916\u4fe1\u606f\u662f\u8d85\u94fe\u63a5,\u800c\u4e14\u8986\u76d6\u4e86\u4e00\u4e2a\u533a\u95f4,\u5728firstRowIndex:{},firstColumnIndex;{},lastRowIndex:{},lastColumnIndex:{},\u5185\u5bb9\u662f:{}", new Object[]{extra.getFirstRowIndex(), extra.getFirstColumnIndex(), extra.getLastRowIndex(), extra.getLastColumnIndex(), extra.getText()});
                    break;
                }
                throw new RuntimeException("Unknown hyperlink!");
            }
            case MERGE: {
                log.debug("\u989d\u5916\u4fe1\u606f\u662f\u5408\u5e76\u5355\u5143\u683c,\u800c\u4e14\u8986\u76d6\u4e86\u4e00\u4e2a\u533a\u95f4,\u5728firstRowIndex:{},firstColumnIndex;{},lastRowIndex:{},lastColumnIndex:{}", new Object[]{extra.getFirstRowIndex(), extra.getFirstColumnIndex(), extra.getLastRowIndex(), extra.getLastColumnIndex()});
                if (extra.getRowIndex() < this.headRowNumber) break;
                this.extraMergeInfoList.add(extra);
                break;
            }
        }
    }

    public List<CellExtra> getExtraMergeInfoList() {
        return this.extraMergeInfoList;
    }
}

