/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.excel.convert;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.convert.Convert;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.ReadConverterContext;
import com.alibaba.excel.converters.WriteConverterContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.icetech.excel.anno.ExcelDictFormat;
import com.icetech.excel.convert.DictContext;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelDictConvert
implements Converter<Object> {
    private static final Logger log = LoggerFactory.getLogger(ExcelDictConvert.class);

    public Class<Object> supportJavaTypeKey() {
        return Object.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return null;
    }

    public Object convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        ExcelDictFormat anno = this.getAnnotation(contentProperty.getField());
        String label = cellData.getStringValue();
        return Convert.convert(contentProperty.getField().getType(), (Object)DictContext.getCurrentContext().getValue(label, anno));
    }

    public Object convertToJavaData(ReadConverterContext<?> context) throws Exception {
        return super.convertToJavaData(context);
    }

    public WriteCellData<?> convertToExcelData(WriteConverterContext<Object> context) throws Exception {
        if (Objects.isNull(context.getValue())) {
            return new WriteCellData("");
        }
        ExcelDictFormat anno = this.getAnnotation(context.getContentProperty().getField());
        String value = Convert.toStr((Object)context.getValue());
        return new WriteCellData(DictContext.getCurrentContext().getLabel(value, anno));
    }

    private ExcelDictFormat getAnnotation(Field field) {
        return (ExcelDictFormat)AnnotationUtil.getAnnotation((AnnotatedElement)field, ExcelDictFormat.class);
    }
}

