/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.excel.convert;

import com.icetech.common.utils.SpringUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.excel.DictService;
import com.icetech.excel.anno.ExcelDictFormat;
import com.icetech.excel.utils.ExcelUtil;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class DictContext
extends ConcurrentHashMap<String, String> {
    public static final String VALUE_PREFIX = "$";
    public static final String TITLE_PREFIX = "#";
    protected static Class<? extends DictContext> contextClass = DictContext.class;
    protected static final ThreadLocal<? extends DictContext> THREAD_LOCAL = ThreadLocal.withInitial(() -> {
        try {
            return contextClass.newInstance();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    });

    public static DictContext getCurrentContext() {
        return THREAD_LOCAL.get();
    }

    public String getValue(String label, ExcelDictFormat anno) {
        String value;
        String type = anno.dictType();
        if (StringUtils.isBlank((CharSequence)type)) {
            value = ExcelUtil.reverseByExp(label, anno.readConverterExp(), anno.separator());
        } else {
            DictContext dictContext = THREAD_LOCAL.get();
            String key = VALUE_PREFIX + type + "-" + label;
            if (Objects.nonNull(dictContext) && StringUtils.isNotEmpty((CharSequence)((CharSequence)dictContext.get(key)))) {
                return (String)dictContext.get(key);
            }
            value = ((DictService)SpringUtils.getBean(DictService.class)).getDictValue(type, label, anno.separator());
            this.set(key, value);
        }
        return value;
    }

    public String getLabel(String value, ExcelDictFormat anno) {
        String label;
        String type = anno.dictType();
        if (StringUtils.isBlank((CharSequence)type)) {
            label = ExcelUtil.convertByExp(value, anno.readConverterExp(), anno.separator());
        } else {
            DictContext dictContext = THREAD_LOCAL.get();
            String key = TITLE_PREFIX + type + "-" + value;
            if (Objects.nonNull(dictContext) && StringUtils.isNotEmpty((CharSequence)((CharSequence)dictContext.get(key)))) {
                return (String)dictContext.get(key);
            }
            label = ((DictService)SpringUtils.getBean(DictService.class)).getDictLabel(type, value, anno.separator());
            this.set(key, label);
        }
        return label;
    }

    public void set(String key, String value) {
        if (value != null) {
            this.put(key, value);
        } else {
            this.remove(key);
        }
    }

    public void unset() {
        THREAD_LOCAL.remove();
    }
}

