/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.excel.convert;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.util.DateUtils;
import java.text.ParseException;
import java.util.Date;

public class TimestampSecondStringConverter
implements Converter<Long> {
    public Class<?> supportJavaTypeKey() {
        return Date.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public Long convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws ParseException {
        return contentProperty != null && contentProperty.getDateTimeFormatProperty() != null ? DateUtils.parseDate((String)cellData.getStringValue(), (String)contentProperty.getDateTimeFormatProperty().getFormat()).getTime() / 1000L : DateUtils.parseDate((String)cellData.getStringValue(), null).getTime() / 1000L;
    }

    public WriteCellData<?> convertToExcelData(Long value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        return contentProperty != null && contentProperty.getDateTimeFormatProperty() != null ? new WriteCellData(DateUtils.format((Date)new Date(value * 1000L), (String)contentProperty.getDateTimeFormatProperty().getFormat())) : new WriteCellData(DateUtils.format((Date)new Date(value * 1000L), (String)"yyyy-MM-dd HH:mm:ss"));
    }
}

