/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.db.mybatis.generator;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.ITypeConvert;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.converts.MySqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.po.TableFill;
import com.baomidou.mybatisplus.generator.config.rules.DbColumnType;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.icetech.db.mybatis.generator.GenerateConfig;
import java.util.ArrayList;
import java.util.Objects;

public class GeneratorUtil {
    private static final String DATE_TIME = "datetime";
    private static final String TIMESTAMP = "timestamp";

    public static void execute(GenerateConfig generateConfig) {
        AutoGenerator mpg = new AutoGenerator();
        GlobalConfig gc = new GlobalConfig();
        gc.setOutputDir(generateConfig.getOutputDir());
        gc.setFileOverride(true);
        gc.setActiveRecord(false);
        gc.setBaseResultMap(true);
        gc.setBaseColumnList(true);
        gc.setEnableCache(false);
        gc.setOpen(false);
        gc.setAuthor(generateConfig.getAuthor());
        gc.setIdType(IdType.AUTO);
        gc.setServiceName("%sService");
        gc.setServiceImplName("%sServiceImpl");
        mpg.setGlobalConfig(gc);
        DataSourceConfig dsc = new DataSourceConfig();
        dsc.setDbType(generateConfig.getDbType());
        dsc.setDriverName(generateConfig.getJdbcDriver());
        dsc.setUrl(generateConfig.getJdbcUrl());
        dsc.setUsername(generateConfig.getJdbcUserName());
        dsc.setPassword(generateConfig.getJdbcPassword());
        dsc.setTypeConvert((ITypeConvert)new MySqlTypeConvert(){

            public DbColumnType processTypeConvert(GlobalConfig globalConfig, String fieldType) {
                if (fieldType.toLowerCase().contains(GeneratorUtil.DATE_TIME) || fieldType.toLowerCase().contains(GeneratorUtil.TIMESTAMP)) {
                    return DbColumnType.DATE;
                }
                return (DbColumnType)super.processTypeConvert(globalConfig, fieldType);
            }
        });
        mpg.setDataSource(dsc);
        StrategyConfig strategy = GeneratorUtil.setStrategy(generateConfig);
        mpg.setStrategy(strategy);
        PackageConfig pc = new PackageConfig();
        pc.setParent(generateConfig.getParentPackage());
        pc.setModuleName(generateConfig.getModuleName());
        pc.setEntity("model");
        pc.setMapper("dao");
        pc.setServiceImpl("service.impl");
        pc.setService("service");
        mpg.setPackageInfo(pc);
        mpg.execute();
    }

    private static StrategyConfig setStrategy(GenerateConfig generateConfig) {
        StrategyConfig strategy = new StrategyConfig();
        strategy.setCapitalMode(false);
        strategy.setRestControllerStyle(true);
        strategy.setEntityLombokModel(true);
        strategy.setEntityTableFieldAnnotationEnable(false);
        if (Objects.nonNull(generateConfig.getTablePrefix())) {
            strategy.setTablePrefix(generateConfig.getTablePrefix());
        }
        strategy.setNaming(NamingStrategy.underline_to_camel);
        strategy.setColumnNaming(NamingStrategy.underline_to_camel);
        strategy.setSuperMapperClass("com.icetech.db.mybatis.base.mapper.SuperMapper");
        strategy.setSuperServiceClass("com.icetech.db.mybatis.base.service.IBaseService");
        strategy.setSuperServiceImplClass("com.icetech.db.mybatis.base.service.impl.BaseServiceImpl");
        strategy.setInclude(generateConfig.getIncludeTables());
        ArrayList<TableFill> tableFills = new ArrayList<TableFill>();
        tableFills.add(new TableFill("create_time", FieldFill.INSERT));
        tableFills.add(new TableFill("update_time", FieldFill.UPDATE));
        strategy.setTableFillList(tableFills);
        return strategy;
    }
}

