package com.icetech.db.utils;

import java.util.Collections;

import com.github.pagehelper.ISelect;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

public class PageHelperUtils {
    public static <T> Page<T> page(int pageNum, int pageSize, ISelect select) {
        return page(pageNum, pageSize, true, select);
    }

    public static <T> Page<T> page(int pageNum, int pageSize, boolean count, ISelect select) {
        try (Page<T> page = PageHelper.startPage(pageNum, pageSize, count)) {
            return page.doSelectPage(select);
        }
    }

    public static <T> PageInfo<T> pageInfo(int pageNum, int pageSize, ISelect select) {
        return pageInfo(pageNum, pageSize, true, select);
    }

    public static <T> PageInfo<T> pageInfo(int pageNum, int pageSize, boolean count, ISelect select) {
        try (Page<T> page = PageHelper.startPage(pageNum, pageSize, count)) {
            PageInfo<T> pageInfo = page.doSelectPageInfo(select);
            if (pageInfo == null) return new PageInfo<>(Collections.emptyList());
            if (pageInfo.getList() == null) pageInfo.setList(Collections.emptyList());
            return pageInfo;
        }
    }
}
