package com.icetech.db.mybatis.base.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import com.icetech.db.mybatis.base.service.IBaseService;
import org.apache.ibatis.binding.MapperMethod;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collection;

/**
 * Description 基础service 实现
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @param <T> the type parameter
 * @author wgy
 * @version 1.0.5
 * @since Date 2019/4/29 9:40 AM
 */
public abstract class BaseServiceImpl<M extends SuperMapper<T>, T> extends ServiceImpl<M, T> implements IBaseService<T> {
    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateBatchByColumn(Collection<T> list, SFunction<T, ?> column, int batchSize) {
        String sqlStatement = getSqlStatement(SqlMethod.UPDATE);
        return executeBatch(list, batchSize, (sqlSession, entity) -> {
            MapperMethod.ParamMap<Object> param = new MapperMethod.ParamMap<>();
            param.put(Constants.ENTITY, entity);
            // entityClass需mybatisplus版本为3.4.1及以上, 之前版本定义为Class<?>
            param.put(Constants.WRAPPER, getLambdaQueryWrapper().eq(column, column.apply(entity)));
            sqlSession.update(sqlStatement, param);
        });
    }

    @Override
    public SuperMapper<T> getSuperMapper() {
        return baseMapper;
    }

    @Override
    public LambdaQueryWrapper<T> getLambdaQueryWrapper() {
        return Wrappers.lambdaQuery(entityClass);
    }

    @Override
    public LambdaQueryWrapper<T> getLambdaQueryWrapper(T entity) {
        return Wrappers.lambdaQuery(entity);
    }
}
