/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.db.config;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.github.pagehelper.PageInterceptor;
import com.icetech.common.properties.TenantProperties;
import com.icetech.db.health.DbHealthIndicator;
import com.icetech.db.interceptor.CustomTenantInterceptor;
import com.icetech.db.mybatis.DateMetaObjectHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DbAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DbAutoConfiguration.class);
    @Autowired
    private TenantProperties tenantProperties;
    @Autowired
    private TenantLineHandler tenantLineHandler;

    @Bean
    @ConditionalOnMissingBean(value={MybatisPlusInterceptor.class})
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        boolean enableTenant = this.tenantProperties.getEnable();
        if (enableTenant) {
            CustomTenantInterceptor tenantInterceptor = new CustomTenantInterceptor(this.tenantLineHandler, this.tenantProperties.getIgnoreSqlList());
            interceptor.addInnerInterceptor((InnerInterceptor)tenantInterceptor);
        }
        interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor(DbType.MYSQL));
        return interceptor;
    }

    @Bean
    @ConditionalOnMissingBean(value={PageInterceptor.class})
    public PageInterceptor pageInterceptor() {
        return new PageInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean(value={DbHealthIndicator.class})
    public DbHealthIndicator dbHealthIndicator() {
        DbHealthIndicator dbHealthIndicator = new DbHealthIndicator();
        log.info("DbHealthIndicator [{}]", (Object)dbHealthIndicator);
        return dbHealthIndicator;
    }

    @Bean
    @ConditionalOnMissingBean(value={DateMetaObjectHandler.class})
    public DateMetaObjectHandler dateMetaObjectHandler() {
        DateMetaObjectHandler metaObjectHandler = new DateMetaObjectHandler();
        log.info("DateMetaObjectHandler [{}]", (Object)metaObjectHandler);
        return metaObjectHandler;
    }
}

