/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import net.sf.json.xml.XMLSerializer;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLTools {
    private static final Logger log = LoggerFactory.getLogger(XMLTools.class);

    public static Map<String, Object> xmlToMap(String xml) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Document document = DocumentHelper.parseText((String)xml);
            Element root = document.getRootElement();
            Iterator iterator = root.elementIterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                if (element.getText().equals("")) continue;
                map.put(element.getName(), element.getText());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return map;
    }

    public static String xml2json(String xmlString) {
        XMLSerializer xmlSerializer = new XMLSerializer();
        JSON json = xmlSerializer.read(xmlString);
        String jsonStr = json.toString().replaceAll("\"", "'").replaceAll("\\[\\[\\]\\]", "{}").replaceAll("\\[\\]", "''");
        return jsonStr;
    }

    public static String json2xml(String jsonString) {
        XMLSerializer xmlSerializer = new XMLSerializer();
        return xmlSerializer.write(JSONSerializer.toJSON((Object)jsonString));
    }

    public static String map2XmlString(Map<String, String> paramMap) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("<xml>");
        Set<Map.Entry<String, String>> entrySet = paramMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            strBuf.append("<" + entry.getKey() + ">");
            strBuf.append(entry.getValue());
            strBuf.append("</" + entry.getKey() + ">");
        }
        strBuf.append("</xml>");
        return strBuf.toString();
    }

    public static String map2XmlStringData(Map<String, String> paramMap) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("<xml>");
        Set<Map.Entry<String, String>> entrySet = paramMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            strBuf.append("<" + entry.getKey() + ">");
            strBuf.append("<![CDATA[");
            strBuf.append(entry.getValue());
            strBuf.append("]]>");
            strBuf.append("</" + entry.getKey() + ">");
        }
        strBuf.append("</xml>");
        return strBuf.toString();
    }

    public static Map<String, String> xmlToMapString(String xml) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Document document = DocumentHelper.parseText((String)xml);
            Element root = document.getRootElement();
            Iterator iterator = root.elementIterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                if (element.getName().equals("hblist")) {
                    String stringValue = element.getStringValue();
                    map.put("rcv_time", stringValue.substring(stringValue.lastIndexOf("201"), stringValue.lastIndexOf("201") + 19));
                    continue;
                }
                if (element.getText().equals("")) continue;
                map.put(element.getName(), element.getText());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return map;
    }
}

